set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7812239';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1214',
      '11402210',
      29.317848,
      81.494747,
      '0301422',
      NULL,
      NULL,
      0.631247,
      NULL,
      '431302',
      5.688688,
      NULL,
      65,
      6.691784,
      NULL,
      NULL,
      NULL,
      1,
      3.111993,
      0,
      1,
      2.326247,
      1,
      2,
      1.686194,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.923040,
      1,
      NULL,
      0.147700,
      3.524154,
      0.696510,
      3,
      2.174087,
      1.004398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.284730,
      1,
      3.350291,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.475790,
      1.913183,
      3.197916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      5,
      6,
      6.193599,
      0.628461,
      0.094190,
      0,
      0,
      NULL,
      1,
      0,
      0.891547,
      NULL,
      1.602430,
      5.996976,
      1.228631,
      1.058741,
      5,
      0,
      4,
      11.748708,
      0.909063,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8,
      3,
      10,
      3.177285,
      4.922158,
      4.630734,
      NULL,
      3,
      0.738096,
      11,
      10,
      NULL,
      4.414502,
      7,
      6,
      1,
      4.232346,
      2,
      10.263207,
      NULL,
      3,
      1.333530,
      1.490982,
      1.532178,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1.349669,
      0.916644,
      0.186738,
      0.872255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.921824,
      NULL,
      NULL,
      NULL,
      NULL,
      1.382707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      11.072414,
      2.509375,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.608221,
      4,
      1.245512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.838672,
      NULL,
      1,
      NULL,
      3.558884,
      3,
      NULL,
      1.246005,
      0.682072,
      1,
      1,
      1,
      NULL,
      1,
      0,
      1,
      1.350028,
      0.883884,
      1.244048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.967913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.542609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.871149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.436615,
      0,
      NULL,
      NULL,
      1,
      0,
      0.846762,
      1,
      0,
      '34131',
      NULL,
      NULL,
      1.162558,
      '',
      '',
      '',
      0.426807,
      '',
      '',
      '',
      4,
      2,
      1,
      1.054732,
      3.905120,
      1,
      NULL,
      0,
      3.424874);
commit;
end;
/


