set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9133722';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '30',
      NULL,
      11,
      NULL,
      96,
      6,
      2,
      2,
      '344342',
      3,
      ' 9-10-1980',
      19.332580,
      8,
      NULL,
      NULL,
      1.363891,
      0.299945,
      2.545258,
      1,
      1,
      1.669549,
      0,
      1.683313,
      1,
      NULL,
      5.769160,
      0.427147,
      2.629103,
      7,
      7.058796,
      1.174690,
      4,
      1.000157,
      5.842830,
      NULL,
      1,
      NULL,
      6.443684,
      1,
      2.010157,
      5,
      2,
      1.558692,
      NULL,
      NULL,
      0.158633,
      NULL,
      NULL,
      5,
      0.397509,
      0.229223,
      1.205941,
      0,
      0,
      NULL,
      0.342065,
      NULL,
      1.161435,
      2.269219,
      1,
      3.637503,
      0.244549,
      0.605887,
      3,
      0.231732,
      3,
      NULL,
      0,
      0,
      1,
      NULL,
      3,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      4,
      1,
      2.707652,
      1.700916,
      NULL,
      0.729761,
      NULL,
      0,
      1,
      NULL,
      1.251750,
      NULL,
      1,
      0.071894,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2.261900,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.749897,
      0,
      1,
      1.479786,
      1,
      1.943073,
      0,
      6,
      NULL,
      7,
      3,
      9,
      0.068275,
      1.561996,
      2,
      NULL,
      1,
      NULL,
      1.770168,
      0.087233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.027715,
      1,
      0,
      1,
      NULL,
      1.275821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3.114607,
      1,
      NULL,
      NULL,
      NULL,
      1.323223,
      1.429435,
      4,
      0,
      NULL,
      NULL,
      1.451448,
      NULL,
      NULL,
      NULL,
      1,
      5.183041,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.999408,
      3.341049,
      NULL,
      2,
      0.955851,
      0,
      NULL,
      0,
      2,
      0,
      0,
      1.513930,
      0,
      1.762397,
      1,
      0.320523,
      1,
      0,
      0.728284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.753178,
      '42444',
      '',
      NULL,
      0.991050,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


