set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9133722';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-1-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '320',
      '03044410',
      NULL,
      16.421322,
      '2011114',
      47,
      6,
      2,
      2,
      NULL,
      5,
      ' 4-29-1992',
      18.109014,
      119,
      1.479001,
      NULL,
      0.478433,
      2,
      NULL,
      NULL,
      1.932409,
      NULL,
      0.567532,
      1.827504,
      0,
      1,
      3.715511,
      0,
      0,
      1,
      1,
      1.353981,
      1,
      1,
      0,
      1,
      0.332117,
      0.645095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.745413,
      0.660671,
      1.084525,
      NULL,
      0.086745,
      3,
      0.597171,
      1.180759,
      0,
      1,
      0,
      0,
      NULL,
      3,
      1.927832,
      NULL,
      3.297631,
      0,
      0.553962,
      0.051091,
      1.855783,
      0,
      2,
      3.607414,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.501574,
      0,
      0,
      NULL,
      0.693253,
      0.298586,
      NULL,
      1.708716,
      0.644967,
      0.745016,
      0.677348,
      1.168684,
      1.920775,
      1,
      0.401743,
      0,
      1,
      0,
      NULL,
      0.054740,
      4,
      1,
      1,
      0.816218,
      0,
      5,
      0.722359,
      1.673279,
      1,
      0.991978,
      3,
      1.873879,
      5.374048,
      1.808890,
      0,
      1,
      0,
      4.199798,
      5.148337,
      6,
      4.998370,
      NULL,
      4,
      6.880576,
      NULL,
      1.574654,
      0.593181,
      0.937473,
      NULL,
      NULL,
      2.414263,
      1.898430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.047847,
      0,
      NULL,
      1.829769,
      0.104488,
      0.822929,
      0.238313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.141470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.724323,
      NULL,
      1.076002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.402513,
      1,
      3,
      1,
      0.621491,
      NULL,
      NULL,
      NULL,
      0.290690,
      3.162927,
      0.750569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.897798,
      3,
      NULL,
      0.871649,
      3.424556,
      2.087357,
      3.538420,
      0.754307,
      3.347554,
      0,
      0,
      0.108543,
      1.245607,
      0.287593,
      1,
      1.537895,
      1.292923,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.480589,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '',
      0,
      NULL,
      NULL,
      '',
      2,
      2,
      0,
      NULL,
      1,
      3.256999,
      2,
      NULL,
      2);
commit;
end;
/


