set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9133722';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '304',
      '32301441',
      10,
      51,
      NULL,
      58.207030,
      5,
      0.941764,
      0,
      '110100',
      0.449313,
      ' 4-12-1985',
      18.541726,
      54.715054,
      1,
      NULL,
      0,
      1.890534,
      NULL,
      0,
      0,
      0.016929,
      NULL,
      3.506362,
      NULL,
      1,
      0,
      0,
      1.554339,
      NULL,
      1.296844,
      1.778473,
      1.894860,
      NULL,
      0.973860,
      1.584083,
      1,
      0.644046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.401565,
      NULL,
      0.585674,
      0.012879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.560224,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.841181,
      1.869747,
      1,
      0.370317,
      1,
      0,
      1.909482,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.182849,
      1.867322,
      1,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      1.693511,
      1.985105,
      2,
      1.372967,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.400085,
      NULL,
      0.623868,
      1.954895,
      0,
      2,
      3,
      4.411103,
      1.121151,
      6,
      5,
      5,
      6.165470,
      0,
      NULL,
      1,
      0.141116,
      NULL,
      NULL,
      0.300702,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.554614,
      1,
      1,
      1.812761,
      NULL,
      NULL,
      0.270647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414882,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.889381,
      1,
      0.981691,
      NULL,
      NULL,
      NULL,
      1.109563,
      1.455172,
      NULL,
      1.450835,
      0,
      1,
      1.084675,
      NULL,
      NULL,
      NULL,
      NULL,
      0.361290,
      1.332162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.825588,
      0.830866,
      1,
      0,
      3,
      2.652642,
      2,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.714943,
      0.654929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '11014',
      '',
      '',
      0.993403,
      NULL,
      NULL,
      NULL,
      0.477788,
      '',
      '',
      '',
      0.225994,
      NULL,
      5,
      0,
      2.868767,
      3,
      2,
      0,
      2.590202);
commit;
end;
/


