set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9133722';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '121',
      '21130444',
      21,
      16,
      '3324241',
      NULL,
      1,
      2.234405,
      1,
      '201421',
      NULL,
      ' 4-21-1974',
      8,
      NULL,
      1,
      NULL,
      0.309394,
      0,
      2,
      1.538725,
      1.859227,
      1.934242,
      1.362080,
      NULL,
      1.180781,
      0,
      NULL,
      1.587743,
      1.104394,
      NULL,
      1,
      0,
      0.836025,
      0.192201,
      0,
      0.275138,
      NULL,
      1.792715,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      3.168740,
      0.378358,
      1.374535,
      3,
      1,
      1,
      NULL,
      1.703215,
      0,
      0,
      NULL,
      0.715567,
      1,
      0,
      2,
      NULL,
      1.488306,
      0.845027,
      1,
      5.967328,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.043357,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.618263,
      NULL,
      NULL,
      1.514138,
      0.978676,
      0,
      1.272605,
      1,
      1.090332,
      0,
      0,
      NULL,
      1,
      0,
      0.604718,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.015648,
      3.990450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.268559,
      NULL,
      2.076810,
      1,
      1,
      3.627844,
      5.397532,
      NULL,
      0.063477,
      0.084422,
      0.892967,
      1,
      9,
      0.952908,
      0.768567,
      NULL,
      0.200150,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.394166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.728034,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      2.293830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.709505,
      1.875333,
      1,
      0.860759,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.297702,
      0.422725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0.384224,
      2.481592,
      1,
      2.457903,
      0,
      NULL,
      NULL,
      NULL,
      1.763325,
      0.133978,
      0.507360,
      1.958137,
      NULL,
      0.106832,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.442960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '41242',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      3.808041,
      2,
      NULL,
      0.786995,
      1.056187,
      1.795040,
      2.370824,
      1.548025,
      0);
commit;
end;
/


