set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9133722';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '041',
      '23223103',
      NULL,
      19.396731,
      '4043031',
      20,
      3,
      NULL,
      2,
      NULL,
      5.640318,
      ' 8-28-1977',
      43,
      NULL,
      NULL,
      NULL,
      0.060153,
      1.182374,
      2.499575,
      0.922032,
      0.091270,
      1.356219,
      NULL,
      0,
      0,
      0,
      1.679558,
      0.134733,
      NULL,
      1,
      NULL,
      1.201986,
      3.203426,
      1,
      0,
      1.568776,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.681219,
      4.587526,
      0.739727,
      0.652027,
      NULL,
      0.460460,
      1.900947,
      0.569400,
      NULL,
      3.455552,
      1,
      NULL,
      NULL,
      0.697019,
      0.438610,
      1.163685,
      2.182001,
      0.410768,
      NULL,
      NULL,
      1.767129,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.598333,
      NULL,
      NULL,
      1.413038,
      NULL,
      NULL,
      1.375016,
      1,
      0,
      NULL,
      NULL,
      0,
      0.261221,
      0,
      0.300059,
      0,
      0,
      0.276643,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      NULL,
      0.574286,
      NULL,
      NULL,
      1,
      1.367810,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      2,
      1.215476,
      1.323331,
      0,
      4,
      1,
      2,
      7.452107,
      5,
      NULL,
      NULL,
      1.502600,
      1.879760,
      1,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.915728,
      0,
      1,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.951346,
      NULL,
      NULL,
      NULL,
      NULL,
      3.357410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      0,
      NULL,
      NULL,
      NULL,
      5.024199,
      NULL,
      2.086679,
      1.698331,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.634395,
      4.202765,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.834775,
      2,
      NULL,
      0.952382,
      0.153018,
      NULL,
      3.069657,
      NULL,
      2.180850,
      0,
      0,
      1,
      1.226519,
      0,
      1.063926,
      1.575865,
      0.171746,
      1.667762,
      0.024542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.129582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '00400',
      '',
      '',
      0.760740,
      NULL,
      '',
      '',
      1.973600,
      '',
      '',
      NULL,
      3.639577,
      3,
      3.604860,
      4,
      NULL,
      NULL,
      0,
      3.314403,
      2);
commit;
end;
/


