set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228957';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-11-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      NULL,
      '3142240',
      22.956192,
      4,
      NULL,
      0,
      '203420',
      1.852893,
      ' 0-14-1987',
      2.553927,
      NULL,
      0.080857,
      NULL,
      1,
      3.197347,
      1.021381,
      1.220120,
      1,
      NULL,
      0.775880,
      0.203058,
      1,
      1.401187,
      3.530184,
      0.842569,
      0,
      0.495745,
      NULL,
      NULL,
      0.585441,
      0,
      NULL,
      3.033014,
      NULL,
      1.652643,
      0,
      1,
      4,
      2,
      1.660127,
      1.333936,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.640424,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.318223,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254769,
      1,
      1.049548,
      NULL,
      1,
      NULL,
      0.979061,
      0.582058,
      NULL,
      0.928365,
      1.661431,
      NULL,
      1,
      1.168963,
      0.547172,
      0,
      NULL,
      NULL,
      0.249969,
      NULL,
      0,
      NULL,
      1,
      1,
      5.724264,
      NULL,
      6,
      0,
      3,
      NULL,
      NULL,
      3,
      1.024621,
      0,
      0,
      0,
      0.072755,
      2.989639,
      NULL,
      5,
      3.810171,
      NULL,
      4,
      8,
      NULL,
      NULL,
      0,
      1.907079,
      1,
      NULL,
      1.219311,
      1.301842,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.286932,
      0,
      1,
      NULL,
      0.176125,
      1,
      1,
      1.771285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.957182,
      NULL,
      NULL,
      NULL,
      NULL,
      7.311839,
      NULL,
      1.925721,
      1,
      NULL,
      NULL,
      1.881658,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1.645586,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.955162,
      NULL,
      0.388076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.407092,
      1,
      NULL,
      1,
      1,
      1.454937,
      1.410043,
      NULL,
      1.071150,
      1.432272,
      0.240910,
      0.196278,
      1.215546,
      0.461342,
      0,
      1,
      1,
      0,
      NULL,
      0.275530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.434877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.420907,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


