set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9858589';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4214',
      '13020410',
      43,
      17.560630,
      '1244143',
      15,
      3,
      1.806604,
      NULL,
      '011101',
      NULL,
      '11-17-1977',
      40,
      3.054086,
      0.545708,
      NULL,
      0.483160,
      2.600064,
      1.732300,
      1.092283,
      1.666385,
      1.780184,
      1,
      0.542903,
      NULL,
      1,
      NULL,
      1.556199,
      1.639198,
      1.510897,
      1.907298,
      0,
      2,
      1.185353,
      0.315367,
      1,
      1.244754,
      1.917282,
      3,
      0,
      1.047755,
      2.700765,
      0,
      1.992159,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.146313,
      0.983939,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.780859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.708611,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      1.022030,
      0,
      0.532214,
      1.909377,
      NULL,
      1.386660,
      0.750315,
      NULL,
      1,
      NULL,
      0,
      0.329876,
      NULL,
      NULL,
      NULL,
      1,
      0.243588,
      1.254228,
      1.671347,
      0,
      NULL,
      0.446061,
      NULL,
      0,
      1.288494,
      NULL,
      5.782653,
      3.807359,
      1,
      5,
      0.507180,
      NULL,
      NULL,
      1.402737,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.720343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.022038,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.394157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.510101,
      3.317779,
      1.419045,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.807375,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.224486,
      1.806932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      1.872763,
      0.886174,
      0.468905,
      1.842250,
      0,
      3.921403,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.923749,
      0,
      0,
      0.594295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.272157,
      '23330',
      '',
      '',
      0.312364,
      '',
      '',
      '',
      2.410386,
      '0441',
      '',
      '',
      3.512769,
      1.380406,
      0,
      0.911830,
      NULL,
      0.231890,
      2,
      0,
      3.299801);
commit;
end;
/


