set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9858589';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4044',
      '04120320',
      52.004312,
      3.108204,
      NULL,
      43.529178,
      6,
      NULL,
      2,
      '433403',
      1.270334,
      '10- 2-1979',
      48,
      13,
      NULL,
      NULL,
      0.304410,
      2,
      0.298811,
      NULL,
      1.408966,
      1,
      0.221378,
      0,
      1,
      0.975444,
      0,
      1.455221,
      1,
      0.156379,
      1.401469,
      NULL,
      NULL,
      0.475382,
      NULL,
      0.683166,
      1.416512,
      1.163982,
      2,
      0,
      2.136639,
      1.426761,
      NULL,
      NULL,
      NULL,
      NULL,
      1.562070,
      NULL,
      NULL,
      0.472184,
      0.594258,
      0,
      1.560686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.809684,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.733738,
      1.652551,
      1,
      0.880346,
      0,
      1.468012,
      1.947499,
      0,
      1.139574,
      0.418355,
      NULL,
      1.465066,
      1.675114,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0.823350,
      5.629255,
      2,
      0,
      1.644210,
      NULL,
      4,
      NULL,
      0.695191,
      1,
      0,
      2,
      0,
      0.554844,
      3.025948,
      5,
      1.565960,
      0,
      6,
      8,
      4.242863,
      0,
      3.224214,
      11.182800,
      8.572677,
      1.574018,
      3.484287,
      2.157341,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.033898,
      1.400539,
      0,
      1.514293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.618220,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.666195,
      1.434143,
      1.902934,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.013000,
      2,
      0.849869,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.114978,
      2,
      1.786132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.861827,
      1.635759,
      NULL,
      3.364501,
      NULL,
      1.515318,
      0.745741,
      2,
      1,
      0,
      0,
      1,
      1.845410,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.458818,
      '12102',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '0023',
      '',
      '',
      4,
      3,
      1.279879,
      5,
      3,
      3,
      1.095976,
      5.091111,
      3.201024);
commit;
end;
/


