set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9858589';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-7-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0134',
      '23331104',
      52,
      85.264516,
      '2411041',
      8,
      5,
      NULL,
      NULL,
      '133102',
      NULL,
      ' 7-25-1985',
      64,
      NULL,
      0,
      NULL,
      1.129887,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.353746,
      1,
      4.000987,
      0.975257,
      NULL,
      0,
      0,
      1.067535,
      2.631189,
      0.944734,
      0,
      0.494803,
      NULL,
      1,
      4,
      1,
      0,
      0.520549,
      1,
      0.483584,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.205219,
      1.383543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.589077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.094693,
      1,
      NULL,
      0.402321,
      0.193354,
      1,
      1,
      NULL,
      1.496940,
      0,
      5.222429,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      2.600369,
      1,
      1,
      NULL,
      1.069248,
      3,
      1.306674,
      0.536020,
      1.783042,
      1.789532,
      2.434283,
      NULL,
      1,
      NULL,
      1.245483,
      2.753930,
      6,
      NULL,
      0,
      7.560201,
      11,
      3.716975,
      5,
      NULL,
      1.069640,
      2,
      0.945185,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.191258,
      0.164140,
      0,
      0,
      1.060998,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.864385,
      NULL,
      0.079286,
      1,
      0.576572,
      4.996828,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      5.115637,
      1,
      3.310612,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.487923,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.932190,
      0.242885,
      0.762807,
      3,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.141219,
      0,
      0.497649,
      1,
      1,
      1.371947,
      1,
      0.223264,
      1.842124,
      1.103457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '04310',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '2103',
      '',
      NULL,
      2,
      NULL,
      1.434929,
      NULL,
      3,
      2.966135,
      0,
      0.887531,
      1);
commit;
end;
/


