set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9427817';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-5-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '414',
      '00',
      7.750849,
      NULL,
      '1403041',
      7,
      4,
      1,
      0,
      NULL,
      3.723719,
      ' 0-21-1978',
      38,
      6.572234,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1.426493,
      0.763194,
      3,
      0.217670,
      0.232423,
      1.352641,
      5.732443,
      NULL,
      0,
      0.513669,
      1,
      5.935271,
      1.862798,
      1.415824,
      1,
      3.848775,
      3,
      NULL,
      0,
      0,
      3.906592,
      NULL,
      1,
      0.823230,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.271899,
      NULL,
      1.120508,
      0.002640,
      0,
      0,
      NULL,
      1,
      2,
      NULL,
      1,
      3,
      2.443082,
      1.704510,
      NULL,
      3.326195,
      NULL,
      3.998535,
      3,
      1.562097,
      0.865660,
      NULL,
      7.375134,
      NULL,
      2,
      3.150923,
      0.143801,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.125271,
      3,
      3.396306,
      0,
      4,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      2.986351,
      0.189035,
      1.684286,
      1,
      1.348733,
      0,
      NULL,
      NULL,
      5,
      4.252747,
      1.524265,
      4.734249,
      NULL,
      5,
      1.684974,
      1,
      1.931084,
      4.983885,
      7,
      5.723426,
      NULL,
      4,
      3.662561,
      NULL,
      1,
      NULL,
      NULL,
      8.346128,
      0,
      3,
      8.143650,
      NULL,
      3,
      NULL,
      2.939700,
      3.066097,
      1,
      NULL,
      6.055496,
      0.526733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.632165,
      1,
      NULL,
      1,
      1.414447,
      NULL,
      3.299011,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.107633,
      NULL,
      NULL,
      NULL,
      NULL,
      3.244694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.871778,
      NULL,
      3.362599,
      0.293549,
      NULL,
      NULL,
      1.513675,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.374135,
      1.442820,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      2.566453,
      0.445068,
      1,
      0,
      1,
      0.151369,
      0,
      NULL,
      0,
      1.910204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '31330',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      0.528097,
      '',
      '',
      '',
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


