set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8935013';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-1-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '204',
      NULL,
      NULL,
      66,
      '2430313',
      111,
      4,
      0.711190,
      3,
      '434201',
      2.599651,
      NULL,
      48.800423,
      NULL,
      1,
      NULL,
      0.175185,
      0.620953,
      2,
      0.162523,
      1.192814,
      1,
      1.834879,
      0,
      0,
      1.000621,
      NULL,
      0.244994,
      NULL,
      1,
      1.732259,
      1.585154,
      3.879780,
      0.821530,
      0.098787,
      0.435900,
      NULL,
      1,
      NULL,
      1,
      1.664068,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.302568,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.930510,
      0.706626,
      1.790061,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.138595,
      3.942849,
      0.937861,
      5,
      2.852074,
      NULL,
      1.844703,
      1.771591,
      0,
      NULL,
      1.124073,
      0.943831,
      5,
      NULL,
      0.963737,
      0.896120,
      1.217274,
      0,
      NULL,
      1.657563,
      5.161697,
      NULL,
      NULL,
      1,
      5,
      2,
      2.156296,
      NULL,
      NULL,
      NULL,
      NULL,
      7.303293,
      4.940859,
      7.306991,
      0,
      1,
      NULL,
      4,
      5,
      NULL,
      NULL,
      NULL,
      5,
      8,
      NULL,
      7.075997,
      2,
      2.514470,
      0,
      1.490892,
      2.242586,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.750364,
      1,
      1,
      0.996672,
      0.309656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.047011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.374247,
      0.568015,
      1.268736,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      6,
      0.703681,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.506396,
      5,
      1.456638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.508396,
      0.244981,
      NULL,
      3,
      0.642385,
      1,
      0.515474,
      0,
      2,
      0,
      1.073301,
      0,
      NULL,
      NULL,
      1,
      1.226515,
      1.063818,
      1.740331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.634579,
      '31430',
      '',
      NULL,
      1.836140,
      '',
      NULL,
      '',
      1.394522,
      '',
      NULL,
      NULL,
      NULL,
      2.288946,
      NULL,
      1,
      5.662955,
      1,
      0.719393,
      NULL,
      2.641602);
commit;
end;
/


