set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8935013';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '220',
      '13231020',
      63,
      NULL,
      '2443033',
      246,
      4,
      2.902488,
      0,
      NULL,
      3.858360,
      ' 9- 0-1993',
      49.842463,
      27,
      0,
      NULL,
      NULL,
      1.659885,
      1,
      0,
      1.727741,
      1,
      0,
      0.436895,
      0,
      1.577112,
      5.941186,
      NULL,
      0,
      0.535033,
      0,
      2.329037,
      NULL,
      0,
      NULL,
      NULL,
      1.630692,
      0.742663,
      0,
      1,
      3,
      0.290907,
      NULL,
      NULL,
      NULL,
      NULL,
      1.868359,
      NULL,
      NULL,
      1.387904,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.087367,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.624201,
      3,
      NULL,
      NULL,
      1,
      5.467072,
      1.574136,
      NULL,
      0,
      5.275059,
      0,
      0,
      0,
      1,
      NULL,
      0.480623,
      1,
      1,
      1,
      NULL,
      1.618735,
      2.901139,
      0.855701,
      1.752057,
      NULL,
      3.441172,
      2,
      0.934147,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      3,
      1.426582,
      1,
      3,
      9.462882,
      9,
      9.973605,
      9,
      4.541009,
      NULL,
      5.506504,
      1,
      3.645715,
      5.069854,
      2.737147,
      1.470825,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.116970,
      NULL,
      0,
      0,
      1.022870,
      0,
      0.863881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.538649,
      1.156789,
      NULL,
      NULL,
      NULL,
      0.276194,
      1.186210,
      7.125867,
      1.889558,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.925626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      NULL,
      2.956566,
      0.032503,
      2.615077,
      NULL,
      NULL,
      3.677499,
      0,
      1,
      NULL,
      0,
      0.070611,
      1.669723,
      1.461701,
      0.985905,
      1.969292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '41041',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      2.976406,
      NULL,
      3.405143,
      NULL,
      NULL,
      1.253228,
      0.404528,
      3.070219);
commit;
end;
/


