set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8935013';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '10112033',
      50.506189,
      60,
      NULL,
      259,
      1,
      NULL,
      3,
      '303012',
      4,
      ' 4-16-1980',
      31,
      18.272384,
      0,
      NULL,
      1.908116,
      0.786130,
      2.044314,
      0.353372,
      0,
      1,
      0.832401,
      NULL,
      1.694710,
      1,
      5,
      NULL,
      0.778952,
      1,
      NULL,
      2.132289,
      1,
      NULL,
      0.138990,
      1.818183,
      1.253338,
      0,
      7,
      NULL,
      0.497058,
      0.924601,
      NULL,
      0.013223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.229832,
      0,
      0.222908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.635826,
      1.916339,
      1,
      NULL,
      0.245973,
      NULL,
      NULL,
      NULL,
      NULL,
      1.946381,
      1,
      1,
      1.152398,
      1.577461,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      0,
      1.869133,
      NULL,
      3.160764,
      NULL,
      NULL,
      NULL,
      NULL,
      5.549867,
      0,
      1.319470,
      1,
      1.038337,
      6.774509,
      6.088603,
      NULL,
      0,
      NULL,
      2,
      NULL,
      3.228084,
      0,
      NULL,
      4,
      3,
      1,
      1.613594,
      4.845537,
      0.738362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.292294,
      0,
      NULL,
      0,
      1.270773,
      1.422303,
      0.458122,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.072247,
      NULL,
      NULL,
      NULL,
      NULL,
      2.163116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.566896,
      1,
      1,
      1,
      0.498479,
      0.832593,
      0,
      1,
      3,
      0,
      1,
      0,
      1.600846,
      NULL,
      NULL,
      NULL,
      1,
      0.504374,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.747084,
      0.601965,
      1.659077,
      0,
      1.443343,
      3.685560,
      1,
      0,
      2,
      0.532384,
      0.916702,
      1,
      0,
      1.389636,
      0,
      0,
      NULL,
      NULL,
      0.653635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11221',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1.753945,
      '',
      '',
      NULL,
      1.580748,
      2,
      0,
      NULL,
      2,
      2,
      NULL,
      2.665844,
      1);
commit;
end;
/


