set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8935013';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1333',
      '32311113',
      64.623142,
      6.688589,
      NULL,
      117,
      NULL,
      0.857064,
      1,
      '142214',
      1,
      NULL,
      46,
      52.892982,
      0.558229,
      NULL,
      0.598312,
      1,
      3,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      1.151260,
      3.203610,
      1,
      0,
      1.655589,
      0.233609,
      NULL,
      3.454946,
      1,
      NULL,
      0.318317,
      NULL,
      0.820039,
      7,
      1,
      1.742807,
      NULL,
      0.614060,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.210472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.986782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.727864,
      0,
      0,
      0.886417,
      0.973130,
      0.093538,
      0.647952,
      1.062229,
      0.193807,
      5,
      0,
      1.132706,
      1,
      NULL,
      1,
      0.609756,
      1,
      0,
      0,
      NULL,
      0,
      0.946955,
      0,
      1.935341,
      1.578696,
      0.264516,
      NULL,
      0.164553,
      NULL,
      NULL,
      NULL,
      NULL,
      0.152357,
      1.895985,
      1.322318,
      0.481792,
      NULL,
      1.662426,
      6,
      3.597901,
      8,
      NULL,
      9,
      7,
      8,
      1.072780,
      3,
      NULL,
      0,
      0.954907,
      1.496087,
      3.862276,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.487244,
      NULL,
      NULL,
      0,
      NULL,
      1.784763,
      0.492904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.010326,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.473769,
      1.181506,
      5,
      1,
      0,
      0,
      0.507215,
      NULL,
      NULL,
      NULL,
      1.090345,
      0,
      1.788787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.467774,
      0,
      NULL,
      1,
      NULL,
      1,
      3.782848,
      0.903270,
      0,
      NULL,
      3.193986,
      NULL,
      1,
      0,
      1,
      1.395917,
      0.217368,
      1,
      NULL,
      0.797166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.324562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '42432',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1.103479,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      2.103583,
      1);
commit;
end;
/


