set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8935013';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-1-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2242',
      NULL,
      25.047217,
      2.239641,
      '1040133',
      114,
      0,
      3,
      2,
      '332410',
      3.890015,
      ' 3-16-1986',
      NULL,
      17.968470,
      1,
      NULL,
      0.059023,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      0.626483,
      NULL,
      NULL,
      7.247328,
      1,
      1.502867,
      1.473523,
      1,
      4,
      5,
      1.935719,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      3,
      0,
      0.576954,
      1.204533,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.394845,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.820389,
      1.619071,
      NULL,
      0.712344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.230826,
      1,
      NULL,
      0.589829,
      3.676911,
      4,
      1,
      0.590736,
      3.695609,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.730904,
      0,
      1.153118,
      NULL,
      0.792449,
      0,
      NULL,
      1,
      4,
      1.463674,
      0.447186,
      0.043429,
      NULL,
      NULL,
      NULL,
      NULL,
      2.596579,
      NULL,
      2.667839,
      0,
      NULL,
      0,
      2,
      3,
      8,
      9.813051,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      1,
      NULL,
      1.083818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.441699,
      1,
      0,
      1,
      1.717336,
      1.939066,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.062064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.114568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      5,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.926449,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.143764,
      1,
      NULL,
      0.851537,
      3.795829,
      2,
      2,
      1,
      2.327434,
      3,
      0,
      0.380949,
      NULL,
      0.401151,
      0,
      1.972889,
      0.772882,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      '',
      3,
      2.776020,
      NULL,
      0.115442,
      NULL,
      3,
      NULL,
      3.777169,
      3.388074);
commit;
end;
/


