set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8935013';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2400',
      NULL,
      NULL,
      64,
      '0210312',
      180.079606,
      0,
      1.232214,
      NULL,
      NULL,
      4.257173,
      '11- 0-2003',
      5.262090,
      23.830124,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      0.267915,
      1.547784,
      NULL,
      NULL,
      1.006109,
      0,
      0.327113,
      3.716208,
      1.640591,
      0.079500,
      0.847551,
      0,
      0,
      1,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.513542,
      NULL,
      NULL,
      1.529072,
      0.976564,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.260891,
      1,
      0,
      0.520880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.459900,
      1,
      1,
      NULL,
      4.338289,
      1.185496,
      NULL,
      0.178424,
      0,
      1.806352,
      NULL,
      1.174080,
      2.858557,
      NULL,
      NULL,
      0,
      NULL,
      0.627051,
      NULL,
      0.994196,
      2.714188,
      NULL,
      NULL,
      2.608361,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      4,
      2,
      1,
      4.932686,
      4,
      3.091440,
      NULL,
      NULL,
      7.762877,
      8.795929,
      1,
      NULL,
      0,
      2,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0.449131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.523524,
      1.965292,
      1,
      1,
      1,
      0.086776,
      1.870554,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.260665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.664143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.758205,
      6.992139,
      0,
      0.923826,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.971919,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.490190,
      NULL,
      2,
      1.341309,
      0,
      3.860993,
      NULL,
      3.169528,
      NULL,
      NULL,
      2,
      0.827149,
      1.293697,
      0.093836,
      1.196727,
      0.009958,
      0,
      NULL,
      1.662926,
      0.255116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.716173,
      '34314',
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      1.938394,
      NULL,
      '',
      '',
      NULL,
      1.041564,
      3,
      2,
      0.201656,
      0,
      NULL,
      NULL,
      3.532966);
commit;
end;
/


