set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9698051';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '42431440',
      12.219010,
      19.095466,
      '0301303',
      37.271108,
      4,
      3.203033,
      3,
      '134341',
      3.363254,
      ' 4-21-2003',
      268,
      10.593808,
      0,
      NULL,
      2,
      1.182380,
      NULL,
      1.373149,
      NULL,
      NULL,
      1,
      0,
      0,
      1.532759,
      4,
      1,
      0.712797,
      1,
      0.677156,
      0.140092,
      NULL,
      1.814335,
      0,
      0,
      1,
      0.234261,
      3,
      1,
      0.175259,
      0,
      1,
      0.628247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.882732,
      1.923165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      3.184676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.822023,
      5,
      2.025252,
      3,
      5.225407,
      5,
      1.678358,
      NULL,
      1,
      0.564008,
      1.708556,
      3.244364,
      NULL,
      NULL,
      0.361474,
      1.345211,
      0.208424,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3.850101,
      0.501543,
      0,
      3,
      2,
      1,
      1.251714,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1.003856,
      3.712745,
      0.088632,
      0.345776,
      NULL,
      NULL,
      NULL,
      5,
      9.570275,
      4,
      NULL,
      3,
      3.265841,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.276272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.121964,
      NULL,
      1,
      0,
      0.764843,
      3.795195,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.366749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.516539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.519367,
      1,
      2.604843,
      1.539487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.349601,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.270840,
      0,
      0,
      3.639795,
      NULL,
      2,
      2,
      0,
      3.312902,
      1,
      0,
      1,
      NULL,
      0.773997,
      1,
      1,
      0.827584,
      0.192812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.410506,
      '14022',
      '',
      '',
      3.544979,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      4,
      2,
      NULL,
      0,
      7.583104,
      2,
      NULL,
      2,
      3);
commit;
end;
/


