set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9698051';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '33421003',
      35.825198,
      37,
      '0200102',
      25,
      5,
      0.736468,
      NULL,
      NULL,
      3,
      ' 0-16-1974',
      249.718658,
      123.413593,
      0,
      NULL,
      0.514917,
      1.443387,
      1.978503,
      1,
      NULL,
      2.494640,
      0.268320,
      0,
      2.528368,
      0.929633,
      4.719780,
      NULL,
      1.065202,
      1,
      0.635726,
      1,
      6.707428,
      0.003073,
      3,
      0,
      0,
      1.187238,
      0,
      NULL,
      0.106320,
      0.568087,
      0.149787,
      0.654937,
      NULL,
      NULL,
      1.882896,
      NULL,
      NULL,
      2,
      0.347381,
      3.343613,
      3,
      1,
      0.075281,
      0,
      NULL,
      NULL,
      0,
      0.439964,
      1.406730,
      NULL,
      0,
      0.966188,
      0,
      1,
      1.248096,
      3.238829,
      NULL,
      NULL,
      0.756098,
      5,
      1,
      NULL,
      3,
      1.637267,
      NULL,
      NULL,
      0.517409,
      NULL,
      NULL,
      1.733933,
      4.909454,
      9,
      4.512333,
      4.028749,
      NULL,
      NULL,
      0.022504,
      1,
      0.748733,
      1,
      NULL,
      1.066248,
      4,
      1.879704,
      1.384127,
      1,
      1.868161,
      NULL,
      NULL,
      1.653874,
      1,
      NULL,
      NULL,
      NULL,
      4,
      5,
      1,
      NULL,
      1,
      1,
      5,
      3,
      2.664634,
      2.804514,
      NULL,
      0.082114,
      NULL,
      4,
      7,
      1,
      2,
      1,
      7.503754,
      3,
      0.780783,
      2,
      3,
      1.436038,
      NULL,
      0,
      3.297398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      1,
      NULL,
      3.181384,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.293206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      0,
      1.358994,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.220322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.677197,
      1.658246,
      1.369016,
      0,
      1,
      NULL,
      3.470427,
      NULL,
      1.185458,
      NULL,
      0,
      0.345864,
      1.828150,
      0,
      0,
      NULL,
      1.987833,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.165765,
      '23140',
      '',
      '',
      3.759712,
      '000',
      NULL,
      '',
      0.953758,
      '',
      '',
      '',
      3.012503,
      3.271067,
      2,
      2,
      NULL,
      2.307191,
      3,
      2,
      0.017855);
commit;
end;
/


