set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9698051';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '210',
      '20330201',
      63.262798,
      NULL,
      NULL,
      66.495509,
      5,
      NULL,
      2,
      '314022',
      2.526336,
      ' 7- 8-1982',
      209,
      31,
      1,
      NULL,
      NULL,
      0.157040,
      1.492216,
      1,
      0,
      2,
      0.953992,
      0.456419,
      0.225542,
      1.468011,
      NULL,
      0.223715,
      NULL,
      0,
      0,
      0.810616,
      0,
      2.058523,
      1.012763,
      1,
      0,
      NULL,
      NULL,
      0,
      3.723790,
      0.304819,
      0.469234,
      0.583565,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.423668,
      1,
      1,
      0.041078,
      0.485513,
      1.834607,
      1,
      1,
      2.074114,
      2,
      0.557962,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      0.971158,
      NULL,
      0,
      0,
      5,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      5,
      0,
      5,
      5.212497,
      NULL,
      0,
      0.739292,
      1.319692,
      0,
      NULL,
      2,
      1,
      1.250182,
      0.940032,
      1,
      NULL,
      1.398659,
      1,
      NULL,
      0,
      0,
      1,
      0.479808,
      2,
      NULL,
      0.578555,
      0.160592,
      0,
      2.418095,
      5,
      0.548031,
      1,
      0.496247,
      3,
      NULL,
      0,
      NULL,
      0,
      0.187775,
      3,
      8,
      0.775165,
      1,
      8.044286,
      1.885792,
      7.652723,
      5.026945,
      1,
      0,
      1.995323,
      0.196312,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.024272,
      0,
      0,
      1,
      1.172573,
      5,
      0,
      0.933244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.259295,
      1,
      1.712186,
      2,
      1.920482,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.480023,
      3,
      1.114173,
      3.250187,
      NULL,
      1.639915,
      0,
      0.559134,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      0.841025,
      1,
      1.086370,
      NULL,
      1.185084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.119066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      '',
      0,
      '343',
      '',
      '',
      0.332355,
      '',
      '',
      NULL,
      3,
      3,
      2.197703,
      1.838286,
      1,
      0,
      NULL,
      1,
      2);
commit;
end;
/


