set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9698051';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '341',
      '22400201',
      NULL,
      54,
      '4323403',
      89,
      3,
      0.671235,
      3,
      NULL,
      NULL,
      ' 6- 2-1988',
      145.391769,
      72.499113,
      1,
      NULL,
      NULL,
      1,
      0.620442,
      NULL,
      0,
      1.893032,
      0.582478,
      1,
      1.856884,
      1.302201,
      0,
      1,
      1.606738,
      NULL,
      NULL,
      1.914658,
      4.463005,
      NULL,
      1,
      0.857981,
      0.004689,
      1.480910,
      NULL,
      0,
      1.409476,
      0.416930,
      NULL,
      1,
      NULL,
      NULL,
      0.049444,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.381935,
      1,
      3.308680,
      1.102305,
      0.190574,
      3,
      2.825226,
      0,
      0.088765,
      2.347723,
      1,
      1.204014,
      0,
      3,
      1,
      0.959685,
      0,
      1.939071,
      1,
      0,
      1,
      NULL,
      0.764031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.266692,
      3,
      1.333927,
      5.394376,
      NULL,
      0,
      0.625595,
      0,
      1,
      1.590200,
      1,
      5,
      NULL,
      0,
      0,
      0,
      1.806874,
      NULL,
      0,
      NULL,
      NULL,
      1.637677,
      0.801748,
      1,
      1,
      0,
      NULL,
      5.184798,
      3.802694,
      NULL,
      0.809121,
      3,
      2,
      2,
      1,
      NULL,
      4.285681,
      4.962388,
      NULL,
      0.584702,
      5.067803,
      8,
      4,
      2,
      7,
      2.583277,
      NULL,
      0.193582,
      NULL,
      NULL,
      0.944082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.925349,
      0,
      1,
      0,
      0.284035,
      3,
      NULL,
      0.837095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.682677,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.659700,
      NULL,
      0,
      1,
      NULL,
      0.547734,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.333093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.929902,
      0,
      1,
      1.876249,
      1,
      2.372886,
      1,
      2.256637,
      NULL,
      0.060549,
      0,
      0,
      0.545154,
      0.581271,
      1.867634,
      1.669015,
      1.165497,
      0,
      1.901568,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.820825,
      '31143',
      '',
      '',
      2,
      '310',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      1.668543,
      2,
      3,
      2,
      2,
      NULL,
      0.701619,
      NULL);
commit;
end;
/


