set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9698051';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12224412',
      36.212241,
      NULL,
      '0403234',
      NULL,
      NULL,
      0.231823,
      3,
      NULL,
      NULL,
      NULL,
      233,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.169007,
      1,
      0.148744,
      0,
      3,
      2.919655,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1.569230,
      NULL,
      1.658435,
      NULL,
      NULL,
      2,
      0,
      0.645813,
      NULL,
      0.128875,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      3,
      0,
      2.288366,
      1,
      NULL,
      0,
      1.470177,
      NULL,
      2,
      1.239511,
      NULL,
      1,
      2,
      0,
      NULL,
      2.852874,
      3,
      1,
      NULL,
      1.635871,
      1,
      1,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.649865,
      0,
      NULL,
      5,
      0,
      0,
      0.745624,
      NULL,
      0,
      NULL,
      0,
      3,
      NULL,
      1,
      0,
      NULL,
      0.968400,
      NULL,
      1,
      5,
      1.050492,
      1,
      0.365099,
      4.462288,
      5,
      0,
      3.430095,
      1.002896,
      2,
      NULL,
      4.104931,
      4,
      0,
      3,
      7.245379,
      NULL,
      7,
      1.232707,
      3.231063,
      NULL,
      NULL,
      3.835628,
      2.495864,
      5,
      4,
      4,
      0.290403,
      NULL,
      NULL,
      7.853262,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.015930,
      1,
      0,
      NULL,
      3.542355,
      1,
      0.185535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.133456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.597858,
      5.444797,
      0.860254,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.673906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.319991,
      3,
      0.028436,
      0.134282,
      0.996988,
      1.721982,
      0,
      1,
      2.250208,
      1,
      1.226982,
      0,
      1,
      0.004966,
      0,
      0,
      1.415054,
      1.661199,
      1.320112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.138040,
      '30434',
      NULL,
      '',
      NULL,
      '141',
      '',
      '',
      0,
      NULL,
      '',
      '',
      1,
      2,
      1.501149,
      0.055277,
      0.765681,
      2.781869,
      2.170147,
      NULL,
      2.518593);
commit;
end;
/


