set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9698051';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0121',
      NULL,
      32,
      32.002640,
      '0322023',
      3,
      3,
      0.606637,
      3,
      '420100',
      3.625505,
      NULL,
      9.731917,
      NULL,
      1.712744,
      NULL,
      7.612458,
      0,
      0.624417,
      1.129866,
      0.971090,
      1.333896,
      0.019964,
      NULL,
      0,
      0,
      1.119608,
      0.163839,
      NULL,
      0.401337,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      5,
      0,
      0,
      NULL,
      0,
      1.463089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2.947659,
      0.458013,
      0,
      1.143070,
      1.202663,
      1.537273,
      3.452965,
      1.357119,
      NULL,
      0,
      1.178522,
      0.350622,
      0,
      2.495211,
      1,
      0,
      NULL,
      0.186492,
      1,
      NULL,
      1,
      1,
      0,
      1.192840,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      0.711163,
      1.363099,
      0.935184,
      4.336529,
      1.295722,
      NULL,
      0.546257,
      1.491321,
      0,
      4,
      0,
      4,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.785342,
      2,
      0,
      NULL,
      0,
      3,
      4,
      1.431934,
      0,
      1.909154,
      5,
      NULL,
      3.660971,
      NULL,
      5.940164,
      2.991451,
      5,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      8.105553,
      3,
      7,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.684942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0.838679,
      3.275392,
      3.990141,
      1.460469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.160802,
      1.206888,
      1.080982,
      0.399594,
      NULL,
      0,
      1.340775,
      NULL,
      NULL,
      NULL,
      0.896899,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3.650115,
      0,
      0,
      NULL,
      NULL,
      3.310765,
      0,
      1,
      1.339026,
      NULL,
      0,
      1,
      1,
      0.398871,
      NULL,
      1.571800,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '02434',
      '',
      '',
      2.203330,
      '310',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      3.766944,
      0,
      3,
      3.170024,
      3.192908,
      2,
      1,
      2.880745,
      NULL);
commit;
end;
/


