set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9698051';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3201',
      '40300333',
      92.863469,
      79.822254,
      '0232430',
      143,
      0,
      2,
      1,
      '242130',
      1,
      ' 0-17-2002',
      264,
      NULL,
      1.963667,
      NULL,
      3,
      NULL,
      NULL,
      1.622867,
      0,
      0.205879,
      1,
      NULL,
      1.672197,
      1,
      3,
      NULL,
      1,
      0.292056,
      1.557398,
      1.197249,
      NULL,
      0,
      NULL,
      1.441136,
      NULL,
      0.569052,
      6,
      1,
      1.914872,
      NULL,
      0.054280,
      0.510201,
      NULL,
      NULL,
      0.447125,
      NULL,
      NULL,
      6,
      1,
      1,
      3,
      0,
      0.426253,
      3.907589,
      0.404787,
      0.117783,
      NULL,
      NULL,
      NULL,
      2.839994,
      0,
      0,
      1.251924,
      3,
      0,
      1.587040,
      0.863440,
      NULL,
      0,
      5.699987,
      0,
      1,
      0.128936,
      1.689097,
      NULL,
      NULL,
      0.889640,
      NULL,
      NULL,
      2.112981,
      0.753449,
      1,
      3,
      1,
      2,
      NULL,
      1,
      3.815265,
      0.030124,
      0.392983,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.511473,
      0.510059,
      NULL,
      NULL,
      0.302188,
      5,
      NULL,
      0.076473,
      1.902808,
      5,
      4,
      1.010521,
      NULL,
      0,
      0.544079,
      2.673587,
      1,
      0.871005,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      5,
      0.625722,
      1,
      7.535039,
      3.017937,
      9.281728,
      NULL,
      3,
      4.022994,
      1.901242,
      0.739447,
      NULL,
      1,
      0.183203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      1.125548,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.689139,
      NULL,
      NULL,
      NULL,
      NULL,
      1.439161,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.821627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.991875,
      1.669815,
      4,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.828087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.032140,
      0,
      3.245586,
      1,
      2,
      0.279148,
      3.444924,
      0,
      NULL,
      1,
      3.724847,
      1.025187,
      1,
      0,
      1.760887,
      NULL,
      1.900813,
      0.533954,
      0.780191,
      0.269899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '12022',
      '',
      NULL,
      0,
      '444',
      NULL,
      '',
      1.071221,
      NULL,
      '',
      NULL,
      2,
      7.298172,
      NULL,
      3.384688,
      3.300039,
      1,
      2.025825,
      1,
      NULL);
commit;
end;
/


