set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9698051';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2043',
      NULL,
      85,
      24.887898,
      '4233113',
      89,
      NULL,
      0,
      NULL,
      '204331',
      4,
      ' 2-12-1976',
      37.681263,
      44,
      0.342337,
      NULL,
      2.998170,
      0,
      2,
      0.288054,
      1.332834,
      3,
      0.605342,
      0.154488,
      3,
      0.875825,
      1.582773,
      0,
      0.271750,
      0.327730,
      1.229526,
      0,
      2.332579,
      NULL,
      NULL,
      0,
      1.356840,
      0,
      1.161637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.463958,
      0.728307,
      0.259120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.189226,
      1,
      1,
      1.950266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.065339,
      0.489617,
      2,
      5,
      1,
      1.816473,
      1,
      0,
      1.657627,
      0.528507,
      1,
      1,
      1,
      0.287865,
      0.716407,
      0.322356,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      1,
      NULL,
      3,
      0.025911,
      NULL,
      1,
      NULL,
      3.891219,
      1,
      3,
      NULL,
      1.244332,
      0,
      6.076606,
      1,
      7,
      1,
      2.777477,
      0.684676,
      2.115130,
      6.664279,
      NULL,
      5.498392,
      NULL,
      0,
      NULL,
      NULL,
      6.238834,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.060407,
      NULL,
      0,
      0,
      0.369659,
      NULL,
      1.370270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.112794,
      NULL,
      NULL,
      NULL,
      NULL,
      3.990334,
      0,
      3.226545,
      0,
      1.468821,
      NULL,
      1,
      2.269723,
      1.109289,
      NULL,
      NULL,
      NULL,
      1.708764,
      0.846107,
      1,
      1.868250,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.450805,
      3.741634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.874757,
      0.514157,
      0,
      0,
      3,
      3.216377,
      2.978488,
      0,
      3.576948,
      NULL,
      0,
      1.568503,
      NULL,
      1,
      1,
      1.523690,
      0.355836,
      1,
      1.581983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.438262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '04423',
      '',
      NULL,
      3.658485,
      '213',
      '',
      '',
      0,
      '',
      NULL,
      '',
      5.798432,
      0,
      1.173898,
      0,
      2,
      NULL,
      NULL,
      1.458929,
      1.935633);
commit;
end;
/


