set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9537645';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '11312011',
      NULL,
      67.449253,
      NULL,
      111,
      0,
      2.471287,
      NULL,
      '440241',
      3,
      ' 2- 1-2003',
      8.676538,
      11.196177,
      0.936623,
      NULL,
      1.574422,
      NULL,
      0.903284,
      0.588713,
      0.928954,
      2,
      0.711368,
      0,
      0.248420,
      NULL,
      1,
      1,
      1,
      1.174099,
      0,
      1,
      0,
      1.195599,
      0.517545,
      0.412847,
      1.988713,
      NULL,
      0.797314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.907494,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.569539,
      NULL,
      0.548547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.484513,
      3,
      1.153435,
      0,
      2,
      2,
      5,
      0,
      1,
      1.707264,
      0,
      1,
      1,
      2,
      1.531136,
      0,
      1.318603,
      1.544222,
      0,
      NULL,
      0.552937,
      1,
      1.310754,
      1,
      0.549938,
      0.445727,
      1,
      0.375094,
      0.364597,
      0,
      1.618112,
      0,
      1.706841,
      0,
      1.963599,
      0.081885,
      1,
      2,
      5.670251,
      4,
      5,
      NULL,
      4.909796,
      7.767719,
      6,
      0,
      4,
      2.712814,
      1,
      NULL,
      NULL,
      9,
      1.142947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.755691,
      0.484614,
      NULL,
      0,
      1.432787,
      0,
      2.802864,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.452678,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.148258,
      1,
      1,
      1.851439,
      0.480134,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.790041,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.956461,
      NULL,
      0.320409,
      0,
      1,
      0,
      1,
      1.057814,
      1,
      0,
      0,
      2,
      0,
      0.931903,
      NULL,
      1.824487,
      0,
      1.155274,
      NULL,
      3,
      NULL,
      2,
      1,
      NULL,
      3,
      0.862285,
      2.037835,
      0.409148,
      0,
      1.386662,
      NULL,
      1.833768,
      1,
      0,
      0.259069,
      NULL,
      NULL,
      NULL,
      1.167167,
      0,
      NULL,
      1.911373,
      0.269728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      '20424',
      NULL,
      1,
      '30443',
      '',
      NULL,
      NULL,
      NULL,
      '11302',
      '',
      1,
      2,
      3,
      NULL,
      1,
      3.439412,
      0,
      4,
      2);
commit;
end;
/


