set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9537645';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-2-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '13404133',
      5,
      63.703183,
      '0414223',
      26.167774,
      5,
      2.402440,
      0,
      '044130',
      4.055644,
      '10-11-1998',
      35,
      29,
      1,
      NULL,
      1.770670,
      1,
      0.706775,
      0.521605,
      1.253491,
      2.609762,
      NULL,
      NULL,
      0.820365,
      0.609887,
      NULL,
      1.640937,
      1,
      1,
      0,
      0,
      0.855710,
      NULL,
      1.459458,
      1,
      1.410037,
      NULL,
      0.352893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.367534,
      1.630081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.422215,
      0.088822,
      2,
      0,
      1,
      NULL,
      1.481479,
      1.029144,
      1,
      0.109249,
      1,
      1.828527,
      1.567548,
      0,
      0.689311,
      1,
      NULL,
      1.952491,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.197928,
      1.399249,
      0,
      0.520783,
      0.743024,
      NULL,
      0.657464,
      1.356014,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.862358,
      2.049158,
      2.039208,
      2,
      3,
      NULL,
      5.097940,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.429107,
      NULL,
      NULL,
      3.173206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.779077,
      NULL,
      1,
      1,
      1.576735,
      NULL,
      1.438607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0.006588,
      1,
      1,
      0,
      NULL,
      3.668490,
      0,
      1.581730,
      NULL,
      0.991901,
      1,
      1,
      2.518657,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.707168,
      2.690547,
      1.128266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.438081,
      NULL,
      0.480166,
      1,
      2,
      NULL,
      0,
      0.387730,
      1,
      1.442514,
      0.535998,
      1.691069,
      1.085062,
      NULL,
      1,
      0,
      0.362164,
      1.777593,
      0.910313,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.880331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '03024',
      '44143',
      NULL,
      3,
      '00433',
      '',
      NULL,
      2,
      '2020',
      '02034',
      '',
      2,
      4,
      NULL,
      2.347390,
      2,
      NULL,
      0,
      4,
      3);
commit;
end;
/


