set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9509348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-11-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      NULL,
      '2244233',
      10.663239,
      3,
      1.134607,
      3,
      '324244',
      2.134819,
      ' 9- 9-1975',
      24.427464,
      NULL,
      0.792104,
      NULL,
      0,
      3,
      0,
      1,
      0.201670,
      1.942928,
      1.503059,
      1,
      2.941232,
      NULL,
      NULL,
      1.779202,
      0,
      1.912747,
      1.985232,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.961843,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      3,
      1.672840,
      NULL,
      0,
      0,
      0.000630,
      2,
      2.150373,
      NULL,
      1,
      2,
      0,
      3.591457,
      1.625670,
      1.665917,
      2.647632,
      2.533799,
      2,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      0.143912,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.504993,
      NULL,
      0.523720,
      0,
      1,
      NULL,
      0.478415,
      NULL,
      0.160004,
      1.363064,
      0,
      1.724802,
      0.351165,
      1.054495,
      1,
      0,
      1,
      0,
      1.132748,
      NULL,
      0.005256,
      0.566682,
      NULL,
      1,
      1.267556,
      1.769834,
      1,
      0.700863,
      NULL,
      1,
      0,
      0,
      1.434661,
      0,
      0.447142,
      6,
      0,
      1,
      NULL,
      2.716864,
      4.022494,
      6,
      1.689804,
      NULL,
      0.765613,
      NULL,
      0.441464,
      NULL,
      3,
      1,
      0.980294,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.466379,
      NULL,
      NULL,
      0,
      1.363562,
      0.585271,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      2.401300,
      0.633582,
      0.305912,
      3,
      0.191989,
      0.221103,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.732972,
      0.720326,
      1.518119,
      1.445554,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.710065,
      1.786586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.879574,
      0.138880,
      0,
      0,
      0,
      0.213610,
      0,
      1.543553,
      NULL,
      0.356520,
      0,
      1,
      0.964880,
      1,
      NULL,
      1,
      0.864240,
      1,
      NULL,
      1.259826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.480786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      '33324',
      '31213',
      '12421',
      1.536219,
      NULL,
      NULL,
      '',
      0,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


