set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9509348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-6-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      NULL,
      NULL,
      NULL,
      14,
      2,
      NULL,
      1,
      '040130',
      0.982480,
      NULL,
      10.742315,
      NULL,
      NULL,
      NULL,
      3.947235,
      1.854183,
      NULL,
      NULL,
      1,
      0.757788,
      1,
      0.567132,
      1.569975,
      0,
      0.185823,
      0.495614,
      NULL,
      7,
      0,
      3.950348,
      3,
      NULL,
      1.167752,
      4,
      1,
      1,
      4,
      1,
      NULL,
      3,
      2.427534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.730554,
      0.723749,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.110254,
      2,
      1,
      NULL,
      1,
      1.359106,
      1.359416,
      3.035749,
      1,
      NULL,
      3,
      10.298141,
      6.455063,
      NULL,
      6.994355,
      0,
      2,
      1.101528,
      1.744576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.207201,
      0,
      NULL,
      0,
      3.953648,
      NULL,
      1.402598,
      0,
      3.104021,
      0.623874,
      0.290201,
      1.399511,
      2.292336,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.299029,
      NULL,
      0.742784,
      NULL,
      1,
      0.131389,
      0.654594,
      1.555737,
      0.382458,
      1,
      NULL,
      1,
      0,
      NULL,
      0.273355,
      3,
      1,
      NULL,
      0,
      2,
      0.695605,
      1.951768,
      3,
      NULL,
      2.270175,
      NULL,
      1,
      2.954779,
      NULL,
      0.551658,
      1.305208,
      9.312210,
      1.980340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.917184,
      NULL,
      1,
      1,
      NULL,
      0,
      1.584285,
      0.608570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.205375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.665288,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.411530,
      1,
      1,
      NULL,
      0.272070,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.417608,
      0,
      0.350134,
      1.209559,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.601337,
      1,
      1,
      1.835294,
      NULL,
      1.917503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.719163,
      '12234',
      '41213',
      '21323',
      0.094540,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


