set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9509348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-11-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '243',
      '14',
      NULL,
      0.744751,
      '2212343',
      2.148255,
      5,
      NULL,
      1,
      '214021',
      2,
      '10- 0-1998',
      24.625944,
      10.971522,
      NULL,
      NULL,
      NULL,
      1,
      1.871530,
      0,
      0,
      2.794724,
      0,
      0.015584,
      0.792994,
      1,
      1,
      0,
      NULL,
      1.934286,
      0,
      NULL,
      3,
      NULL,
      0.068144,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.978593,
      1.456032,
      1.983924,
      1.562611,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      1.688679,
      NULL,
      3.879106,
      0.606458,
      0,
      0,
      2,
      1.061665,
      1.081796,
      0.517836,
      0,
      NULL,
      2.062330,
      0,
      1.697488,
      0.159039,
      3,
      1.954521,
      7.277352,
      1.181631,
      2,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0.553339,
      NULL,
      1.130129,
      0,
      0.875457,
      0.956214,
      0.657362,
      0.885972,
      0.763542,
      NULL,
      1,
      3.187668,
      1,
      0,
      0,
      1.656053,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0.407555,
      NULL,
      1,
      0.750717,
      0.940938,
      1.043219,
      0.970414,
      0,
      NULL,
      0,
      1,
      0.448436,
      1,
      0,
      0,
      3,
      NULL,
      0.849193,
      NULL,
      0.556328,
      3,
      4.066337,
      1,
      NULL,
      1,
      NULL,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.536139,
      1,
      0,
      0.253488,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      8.538181,
      NULL,
      NULL,
      0,
      1,
      1.622882,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.112972,
      1,
      NULL,
      0,
      1,
      1.126991,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.258947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.397379,
      1,
      1.089323,
      0,
      0.280475,
      1.135364,
      1,
      1,
      1.755777,
      NULL,
      3,
      1.934810,
      0.632952,
      0.255510,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.165881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '23020',
      NULL,
      '24440',
      1,
      NULL,
      '',
      '',
      0.564764,
      NULL,
      '',
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


