set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9509348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '144',
      NULL,
      26.144155,
      NULL,
      '0243030',
      NULL,
      5,
      2.349317,
      2,
      '131223',
      2.078060,
      ' 5- 6-1993',
      NULL,
      69.072517,
      0,
      NULL,
      3,
      1.651155,
      1.983033,
      0.952115,
      1.777095,
      1.263759,
      0,
      0.115756,
      1,
      1,
      NULL,
      0.885893,
      1.881241,
      8,
      2,
      NULL,
      0.520319,
      1,
      0.183214,
      7.847196,
      NULL,
      0,
      8.289429,
      1,
      4.009308,
      2,
      0,
      1.968549,
      NULL,
      NULL,
      0.101128,
      NULL,
      NULL,
      10.046384,
      NULL,
      3.712765,
      1,
      1.828485,
      0,
      0,
      1,
      3.268550,
      1.889525,
      1.594620,
      1,
      1,
      NULL,
      0,
      0.911147,
      NULL,
      NULL,
      0,
      5,
      0,
      4.455993,
      NULL,
      0,
      1,
      2,
      1.691967,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      5.754467,
      1,
      3,
      3,
      1,
      1.408105,
      0,
      0.356365,
      1.656044,
      0.788396,
      1,
      2,
      0.876280,
      0,
      1,
      0.491973,
      NULL,
      NULL,
      1.796022,
      NULL,
      0.098900,
      1,
      1.054644,
      1,
      NULL,
      NULL,
      NULL,
      0.037953,
      1,
      0,
      0.712613,
      0,
      NULL,
      NULL,
      7.331982,
      4.470837,
      0.161143,
      8,
      11,
      0.208913,
      NULL,
      NULL,
      5,
      5,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.971858,
      0,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.384792,
      NULL,
      NULL,
      NULL,
      NULL,
      3.637339,
      0.260404,
      1,
      0,
      0,
      NULL,
      1.360369,
      1.275139,
      1.054488,
      NULL,
      NULL,
      NULL,
      4.897781,
      1.791437,
      6,
      6,
      1.043947,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.978071,
      0,
      1,
      3,
      NULL,
      2,
      2.559784,
      0,
      0.231304,
      3.643797,
      1,
      1.436695,
      NULL,
      0.310253,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.025455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '14423',
      '01222',
      '10240',
      1.103397,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


