set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9509348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '342',
      '24',
      21,
      16,
      '3103034',
      33.472197,
      2,
      2,
      1,
      '332420',
      NULL,
      '10-13-1983',
      NULL,
      139,
      1,
      NULL,
      0.074395,
      0.617976,
      NULL,
      NULL,
      1.723464,
      NULL,
      NULL,
      NULL,
      1,
      0.979679,
      1.673709,
      0,
      1,
      9.987445,
      9.114588,
      1.804281,
      2,
      1.515821,
      2,
      NULL,
      0,
      NULL,
      2.408049,
      3,
      1.069511,
      NULL,
      NULL,
      0.117054,
      NULL,
      NULL,
      0.735058,
      NULL,
      NULL,
      3.047683,
      3,
      2,
      0,
      0.274881,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.392577,
      NULL,
      NULL,
      0.538452,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.656490,
      7,
      4.611179,
      1,
      2,
      5,
      0,
      NULL,
      NULL,
      0.086882,
      NULL,
      NULL,
      2.091251,
      NULL,
      4.403962,
      0.194170,
      3,
      1.464472,
      1,
      0.674648,
      0,
      1.510929,
      NULL,
      0,
      1.685432,
      NULL,
      1.131522,
      0,
      1.487027,
      0,
      1,
      NULL,
      1,
      1.762097,
      NULL,
      1,
      3,
      1,
      7,
      1.773658,
      5,
      1,
      NULL,
      1,
      0.256349,
      1,
      5,
      1.983141,
      5.255474,
      6.850334,
      9.839350,
      10,
      9,
      5.882247,
      3.709537,
      7,
      NULL,
      NULL,
      NULL,
      2.228214,
      2.539155,
      NULL,
      0.753301,
      NULL,
      1.878257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.671330,
      NULL,
      1,
      1,
      0.347987,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.790466,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.867626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.418064,
      1,
      NULL,
      NULL,
      NULL,
      1.755227,
      1,
      7.677702,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.364137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.889978,
      1.985249,
      NULL,
      1,
      NULL,
      3.480772,
      0,
      2,
      2,
      NULL,
      3.886151,
      1.659124,
      NULL,
      0.407437,
      1,
      0.355748,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.001266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      '41143',
      '31220',
      '31423',
      1,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      4.366415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


