set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9509348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-11-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '20',
      NULL,
      20.342676,
      '3321331',
      NULL,
      2,
      2.714449,
      NULL,
      '312310',
      3,
      '11- 1-1986',
      25,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.204263,
      3,
      1.558864,
      NULL,
      1,
      1.163245,
      1.385948,
      1.414413,
      NULL,
      3.317740,
      4,
      1.928358,
      NULL,
      1.251300,
      2.040518,
      1.600465,
      0.502560,
      2,
      5.493763,
      0,
      1,
      3.831751,
      2.253836,
      1.472239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0.224066,
      NULL,
      3,
      1.765723,
      1,
      1.642985,
      3.559311,
      NULL,
      NULL,
      0,
      2,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.364268,
      3.175382,
      NULL,
      3,
      1,
      NULL,
      2,
      1.451023,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.617582,
      2,
      0,
      1,
      5.404123,
      NULL,
      2,
      1.102510,
      1.648000,
      1.182696,
      1.383209,
      1.267265,
      1.481089,
      3.314516,
      1,
      1,
      NULL,
      1.604549,
      NULL,
      NULL,
      NULL,
      4,
      1.701649,
      2,
      0.162690,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      5.026586,
      NULL,
      4,
      2,
      NULL,
      4.416430,
      6.298985,
      9,
      7,
      3.659973,
      7,
      11,
      1.495855,
      2.951879,
      NULL,
      NULL,
      1.361857,
      1,
      1.467789,
      4,
      0.122198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.125934,
      1,
      0,
      1,
      0.338773,
      1.432669,
      0.069871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.102303,
      0.518683,
      0.761593,
      NULL,
      NULL,
      NULL,
      3.994431,
      0.537246,
      NULL,
      0.328179,
      0.871676,
      2,
      0.832968,
      NULL,
      NULL,
      NULL,
      NULL,
      3.426150,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.297092,
      NULL,
      0.350817,
      0,
      1,
      NULL,
      2.368837,
      3.747917,
      0.660897,
      NULL,
      0,
      NULL,
      0.663406,
      1,
      1,
      0,
      0,
      0.947665,
      1.416426,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.717527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7.678524,
      '04013',
      '04430',
      NULL,
      1.586081,
      '',
      '',
      '',
      1.475430,
      '',
      '',
      '',
      1.106933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


