set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9509348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-6-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '313',
      '31',
      NULL,
      NULL,
      '4413022',
      67,
      3,
      2,
      NULL,
      '123130',
      0.328048,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.917148,
      1.011354,
      0,
      0.506258,
      1,
      2.960672,
      NULL,
      1.758969,
      1,
      1.382458,
      NULL,
      1.293421,
      NULL,
      6.979776,
      3,
      0.015545,
      5,
      1,
      2.032685,
      1.039798,
      1.166811,
      0,
      3,
      1,
      1.389063,
      NULL,
      2.556318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2.967267,
      2.429670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      2,
      0.462616,
      NULL,
      2,
      0,
      0.658408,
      NULL,
      NULL,
      1.042710,
      NULL,
      NULL,
      4,
      NULL,
      1,
      1.529814,
      3,
      1,
      2.386510,
      NULL,
      0.579299,
      1.428061,
      NULL,
      3,
      3,
      2.659937,
      0.580029,
      1.749483,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      4,
      3.215836,
      NULL,
      2.544369,
      NULL,
      0.718224,
      1.874293,
      4.655287,
      1,
      0,
      0.724639,
      5,
      2.143553,
      5,
      6.804587,
      NULL,
      NULL,
      1.883942,
      NULL,
      NULL,
      7.472710,
      8.436279,
      NULL,
      NULL,
      5,
      0,
      0,
      NULL,
      3.782492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.846104,
      NULL,
      0,
      0,
      NULL,
      3,
      3.388971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.906547,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      2,
      NULL,
      1.792206,
      2.112223,
      3.164566,
      1,
      NULL,
      NULL,
      NULL,
      5,
      0.145374,
      0,
      5.234922,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      5.198136,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.734086,
      NULL,
      0.198559,
      NULL,
      1.122055,
      3.419338,
      1.541409,
      2.164714,
      0.040009,
      NULL,
      1.913693,
      0,
      0.288415,
      0,
      1,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.155266,
      '12223',
      '33344',
      NULL,
      0,
      '',
      '',
      NULL,
      1.815701,
      '',
      '',
      '',
      NULL,
      3.982853,
      0,
      1,
      0,
      NULL,
      1,
      0,
      NULL);
commit;
end;
/


