set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9509348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-1-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '041',
      '03004311',
      NULL,
      48.422461,
      '1240000',
      NULL,
      4,
      3,
      2,
      '411301',
      0.601029,
      ' 9-26-2001',
      NULL,
      NULL,
      0.043419,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      2,
      0,
      0,
      NULL,
      0.291562,
      3.868258,
      0.564411,
      0,
      NULL,
      3,
      1,
      4,
      2.634466,
      1,
      0,
      0.822978,
      2.428423,
      NULL,
      0,
      1,
      2.817791,
      2.922494,
      1.867944,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.042068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.773277,
      1,
      1.573618,
      2,
      1,
      2,
      0.105348,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      0,
      1,
      0.680113,
      2,
      NULL,
      1,
      1,
      0.005432,
      0.239018,
      0,
      NULL,
      1.510246,
      1.411827,
      0.649197,
      1,
      0.348123,
      NULL,
      0,
      1,
      0.229006,
      3.980257,
      3,
      0.316529,
      2,
      1,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.801753,
      0.964307,
      NULL,
      NULL,
      7.507402,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      7,
      0,
      NULL,
      2,
      3.890847,
      0.017063,
      1.222661,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0.811085,
      1.190104,
      1.941732,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      3,
      NULL,
      1,
      1.106768,
      5.615787,
      5.177859,
      0.473451,
      0,
      NULL,
      NULL,
      NULL,
      3.275403,
      0.384683,
      0,
      NULL,
      NULL,
      0,
      1.536067,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.326999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.197812,
      0,
      NULL,
      0.475492,
      3.958675,
      0,
      3.637137,
      1.607318,
      NULL,
      3,
      1.832631,
      NULL,
      NULL,
      0.476770,
      0.373951,
      1.259308,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.158382,
      '40141',
      '03432',
      '43004',
      0,
      NULL,
      NULL,
      '',
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.110316,
      1.420439,
      NULL,
      NULL,
      2,
      2.030181,
      5.876336,
      0);
commit;
end;
/


