set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9768014';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '100',
      '01120203',
      45,
      NULL,
      '4110424',
      2,
      6,
      2.045317,
      2,
      '313104',
      1,
      ' 2-16-2001',
      145,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1.444323,
      1.390777,
      1.561509,
      1.720665,
      0,
      1,
      0.398283,
      0.080655,
      NULL,
      NULL,
      0,
      0.996225,
      NULL,
      0.888179,
      1.321411,
      1,
      NULL,
      NULL,
      NULL,
      4.264547,
      0,
      2.241221,
      NULL,
      0.366010,
      0.651641,
      NULL,
      NULL,
      1.168366,
      NULL,
      NULL,
      1,
      0.245199,
      0.067781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.159387,
      1.728659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.250741,
      1,
      0.556324,
      NULL,
      1.548178,
      2,
      NULL,
      NULL,
      0,
      0.315800,
      0,
      3.321485,
      0.482187,
      3,
      NULL,
      0.708571,
      NULL,
      0.535685,
      0,
      NULL,
      NULL,
      2.052766,
      2.865904,
      1.465422,
      2.881172,
      1,
      7.511652,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.295809,
      1,
      2,
      0.259391,
      2,
      3,
      1.664080,
      5,
      1.688587,
      NULL,
      NULL,
      NULL,
      4,
      1.653101,
      1.054324,
      0.644160,
      1,
      NULL,
      NULL,
      0,
      1.952662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.149787,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.244933,
      NULL,
      NULL,
      NULL,
      NULL,
      2.803816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.992736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      5,
      NULL,
      1.122920,
      2,
      1.545141,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      1.828305,
      1,
      0,
      0.770376,
      1.596078,
      0,
      0.032753,
      2.839836,
      1.782285,
      1.936486,
      NULL,
      1.128640,
      NULL,
      NULL,
      0.398182,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.664183,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.980619,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      5.678792,
      3,
      2.860147,
      1,
      0,
      1,
      2.218306,
      0,
      3.119176);
commit;
end;
/


