set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9768014';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '321',
      '23344441',
      36.121773,
      NULL,
      '3120232',
      NULL,
      NULL,
      NULL,
      2,
      '430201',
      5.223832,
      ' 6-18-1998',
      176.522579,
      NULL,
      1.871146,
      NULL,
      NULL,
      0.882173,
      0.593666,
      0,
      NULL,
      0.568761,
      0.185390,
      1.006209,
      1.850567,
      1.749371,
      2,
      0.356221,
      NULL,
      1.250096,
      1.171812,
      NULL,
      2.342793,
      1.837724,
      NULL,
      NULL,
      1.810991,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.105488,
      1.679092,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.943202,
      0.683425,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.290338,
      NULL,
      0.755657,
      NULL,
      0.018098,
      5.730195,
      0,
      1,
      1,
      1.954030,
      1.923457,
      3,
      NULL,
      4,
      0.159175,
      0.114311,
      0.127043,
      1,
      0.156984,
      NULL,
      NULL,
      1.046460,
      0,
      3,
      3.962291,
      0,
      5,
      1.700099,
      NULL,
      NULL,
      NULL,
      NULL,
      1.022177,
      NULL,
      5,
      1.800950,
      2.681929,
      0.840847,
      4.708398,
      4.542885,
      3,
      9.999271,
      NULL,
      NULL,
      5,
      0.458517,
      1.140212,
      1,
      NULL,
      NULL,
      NULL,
      9.212098,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.006734,
      1,
      1,
      0,
      0.660614,
      NULL,
      1,
      0.029408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.059913,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1.772669,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.247503,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.793931,
      NULL,
      1.401515,
      1,
      1.814913,
      NULL,
      2.399805,
      1.005498,
      0.114181,
      NULL,
      NULL,
      0,
      0.895015,
      1.513226,
      NULL,
      1,
      1.960044,
      0.048122,
      0.317270,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.880154,
      NULL,
      '',
      '',
      0.507257,
      '',
      '',
      '',
      1.028514,
      '',
      '',
      '',
      5,
      2.410242,
      2,
      2,
      NULL,
      4.584392,
      NULL,
      1,
      NULL);
commit;
end;
/


