set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9768014';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      9,
      27.624063,
      '0311211',
      5,
      1,
      0,
      0,
      NULL,
      NULL,
      ' 7-16-1989',
      NULL,
      26.191814,
      1.746385,
      NULL,
      5,
      3.643530,
      3,
      1.843124,
      2,
      NULL,
      1.084854,
      1.968079,
      1,
      NULL,
      2.909107,
      0,
      1,
      1,
      1,
      1.903574,
      3,
      0.503413,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      2.248310,
      3.979335,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.620248,
      1.301324,
      0.368252,
      1.670165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.744195,
      0,
      1.183540,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.640553,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      1.459185,
      1,
      0,
      0.175355,
      2,
      1.296115,
      0,
      0,
      0,
      1,
      NULL,
      0.443457,
      4.226904,
      7.716982,
      0.988840,
      3.151099,
      NULL,
      7.988801,
      1,
      NULL,
      0,
      NULL,
      5,
      0.249118,
      2.803067,
      1.774622,
      0.011552,
      4,
      0.719988,
      2,
      3.214378,
      9.009714,
      NULL,
      5.031457,
      7,
      1.076234,
      1.008455,
      0,
      1,
      0.727282,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.726273,
      1,
      0,
      1.937777,
      2.063357,
      1.446736,
      1.946976,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.107341,
      NULL,
      NULL,
      NULL,
      NULL,
      3.466063,
      1.857723,
      0.059483,
      1.094114,
      1.615686,
      1.503556,
      4.501541,
      3,
      0.394744,
      NULL,
      NULL,
      NULL,
      NULL,
      3.966618,
      6.775411,
      1.875016,
      0.496150,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.391732,
      NULL,
      1.740039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.758660,
      2.855287,
      1,
      NULL,
      NULL,
      3.675115,
      3.885223,
      1,
      NULL,
      NULL,
      1,
      0.409206,
      1,
      0,
      NULL,
      0.179658,
      0.117573,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.501821,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      1.547407,
      NULL,
      3,
      3);
commit;
end;
/


