set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9768014';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      58.128016,
      54.005818,
      '3204201',
      6,
      6,
      0.762970,
      2,
      '310204',
      4,
      '10-19-1977',
      176,
      103,
      NULL,
      NULL,
      1.165823,
      0,
      0,
      1,
      0.071956,
      NULL,
      0.975597,
      1,
      1,
      0,
      6,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.552651,
      3.138927,
      0.615125,
      0.597279,
      0.997448,
      NULL,
      1,
      2,
      0.870742,
      3.661192,
      1.422535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.200320,
      NULL,
      1.143594,
      2.803411,
      NULL,
      NULL,
      1.830585,
      1.216319,
      1,
      0.011375,
      1,
      0,
      1,
      2.640975,
      0.364515,
      0.696052,
      NULL,
      0.418495,
      NULL,
      0.303364,
      1.054910,
      1.570156,
      7,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.286707,
      0.269967,
      0.582684,
      0,
      1.608905,
      1.736111,
      1,
      0.721026,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      1.672971,
      0.614808,
      1.415270,
      NULL,
      0,
      NULL,
      0,
      1,
      1.363611,
      NULL,
      0.093185,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.064737,
      NULL,
      1.768621,
      1.480673,
      NULL,
      1.293670,
      9.776003,
      8.691584,
      5,
      4.294600,
      NULL,
      2,
      0,
      NULL,
      0,
      5.116650,
      1,
      0.069927,
      1.209725,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.578464,
      1,
      0,
      1,
      0.221499,
      0,
      1.263210,
      1.194842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.112565,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3.159419,
      1,
      2.796457,
      0.505327,
      NULL,
      0.002113,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.188014,
      0.294287,
      3.803380,
      1,
      3,
      1.257877,
      1.637495,
      1,
      1,
      1.163774,
      NULL,
      NULL,
      1.730248,
      0,
      0.826291,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '24240',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      0.481700,
      NULL,
      '',
      NULL,
      NULL,
      3.190858,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2);
commit;
end;
/


