set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9768014';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3012',
      NULL,
      50.460399,
      11,
      '3243200',
      51,
      6,
      2,
      1,
      '011213',
      1,
      '10- 6-1981',
      74,
      NULL,
      0,
      NULL,
      0.263323,
      0.106264,
      2.423592,
      0,
      1.300431,
      1.351479,
      1,
      3.988908,
      0,
      NULL,
      3.570154,
      1,
      1,
      1.535740,
      0.341030,
      NULL,
      NULL,
      NULL,
      1.506636,
      1,
      0,
      NULL,
      1.637416,
      1,
      2.933627,
      1.993718,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.802445,
      7,
      3.264399,
      NULL,
      NULL,
      2.751998,
      0,
      0,
      2.309573,
      3.715453,
      0.637117,
      3,
      2,
      1,
      1,
      2.972464,
      1,
      0,
      1,
      0,
      0.957992,
      7,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0.198459,
      NULL,
      NULL,
      0,
      1,
      1.546084,
      1,
      0,
      NULL,
      1,
      0.051308,
      1.977957,
      1,
      0.456887,
      0,
      0.152241,
      0,
      1.168675,
      0,
      0.826159,
      1,
      NULL,
      NULL,
      NULL,
      2.154782,
      1.113769,
      5.048253,
      2.766513,
      0.522919,
      NULL,
      0.058891,
      NULL,
      NULL,
      NULL,
      NULL,
      1.394737,
      4,
      3.806389,
      1.994603,
      4.487471,
      0,
      7.749651,
      6,
      6.346213,
      NULL,
      0.649669,
      6.287605,
      NULL,
      NULL,
      0,
      0,
      2,
      0,
      1.191912,
      0,
      0.507091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.414053,
      0,
      1,
      0,
      0.597727,
      0.885258,
      1,
      0.664445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.407159,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.231289,
      0,
      NULL,
      1.248447,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.453890,
      1.400285,
      3,
      2.117402,
      0.936511,
      NULL,
      NULL,
      1.127453,
      0.942047,
      1,
      1.930828,
      1,
      1,
      0.228167,
      NULL,
      1.411404,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.145859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.456864,
      '20133',
      '',
      '',
      1.692153,
      '',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      0.284669,
      1,
      3.905457,
      2.535786,
      1.233378,
      1,
      3,
      NULL,
      2.888604);
commit;
end;
/


