set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9768014';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-12-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4430',
      '34023230',
      64,
      71,
      '4410210',
      NULL,
      1,
      0,
      2,
      '130401',
      1,
      ' 0-13-1997',
      90.254677,
      14,
      1,
      NULL,
      NULL,
      1.077073,
      1,
      NULL,
      0,
      1.201792,
      1.947700,
      2.838717,
      1.562417,
      0.661703,
      NULL,
      1.759650,
      0.856308,
      1,
      0.835394,
      0,
      NULL,
      0.182919,
      1,
      NULL,
      NULL,
      0,
      6.713470,
      1,
      5.456465,
      1,
      2,
      0,
      NULL,
      NULL,
      0.845353,
      NULL,
      NULL,
      7,
      0.342931,
      NULL,
      2.296386,
      NULL,
      NULL,
      1.788053,
      1,
      1.444193,
      2.378403,
      0.699503,
      0,
      1,
      NULL,
      2.263833,
      1,
      NULL,
      0.369688,
      NULL,
      1.496191,
      0,
      1,
      6,
      NULL,
      2,
      3,
      1.014100,
      NULL,
      NULL,
      1.020227,
      NULL,
      NULL,
      0.040081,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2.756791,
      0.103938,
      1,
      1,
      1,
      1,
      1,
      2,
      0,
      1,
      1.877343,
      NULL,
      1.320216,
      NULL,
      0,
      NULL,
      1.535270,
      0.802100,
      NULL,
      0.476309,
      2,
      0,
      4,
      5,
      NULL,
      2.110033,
      1,
      4,
      1,
      NULL,
      4.673789,
      NULL,
      NULL,
      3,
      6.468407,
      NULL,
      3,
      5.869035,
      NULL,
      4,
      1,
      NULL,
      1.773625,
      NULL,
      0,
      0.891880,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.382141,
      1.459989,
      0,
      1,
      NULL,
      NULL,
      1.251389,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.535188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.328723,
      2.708795,
      1.112140,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.773336,
      3,
      NULL,
      NULL,
      1.673563,
      1.282844,
      2,
      1,
      0.047965,
      NULL,
      1,
      0.922011,
      0,
      1,
      1.705411,
      1.409635,
      0.825339,
      1,
      1.291412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '41434',
      NULL,
      '',
      1.340233,
      NULL,
      '',
      '',
      1.621396,
      '',
      '',
      NULL,
      3,
      NULL,
      NULL,
      0,
      3.582759,
      NULL,
      0,
      2,
      0.970431);
commit;
end;
/


