set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9768014';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1232',
      '30433301',
      37.494731,
      93.026051,
      '3400433',
      122,
      3,
      3,
      NULL,
      '020340',
      5.005318,
      NULL,
      NULL,
      1.646877,
      0.734057,
      NULL,
      0.825356,
      1.782158,
      0,
      1.757145,
      1.409972,
      1,
      0.963911,
      0.082895,
      1,
      0,
      3.291729,
      1.412358,
      0,
      0,
      0.910144,
      NULL,
      0.793471,
      0,
      1,
      1.782124,
      1,
      1,
      NULL,
      0,
      0,
      1.410058,
      0,
      1,
      NULL,
      NULL,
      1.001850,
      NULL,
      NULL,
      1,
      1.803153,
      0.048029,
      3,
      0.761616,
      0,
      0.522444,
      0.695392,
      2.497969,
      1.850554,
      1,
      1.813960,
      1,
      2,
      NULL,
      0,
      2.324244,
      1.544152,
      NULL,
      NULL,
      NULL,
      1,
      3.089344,
      1,
      0,
      1.536745,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.972308,
      0,
      5.893272,
      0,
      NULL,
      NULL,
      1.120084,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      1,
      0.775373,
      1.478737,
      NULL,
      0.961696,
      3,
      NULL,
      NULL,
      3.973938,
      1.903538,
      NULL,
      0.216736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.029728,
      7,
      1.952635,
      2.039209,
      NULL,
      7,
      4.476849,
      5.005160,
      1,
      0,
      1.339260,
      0,
      NULL,
      0,
      4.779847,
      NULL,
      1,
      0.335270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.434054,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.844771,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.469936,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.251141,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      2.396696,
      3.082584,
      0.598841,
      2.742088,
      NULL,
      1.976543,
      0,
      0,
      1.773331,
      NULL,
      0.342520,
      0.096916,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.770304,
      '22041',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      0.178540,
      '',
      '',
      '',
      NULL,
      2.399765,
      2.492969,
      4,
      0,
      NULL,
      1,
      3,
      3);
commit;
end;
/


