set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      NULL,
      NULL,
      '1320341',
      11.793619,
      2,
      2,
      1,
      '304301',
      1,
      NULL,
      19,
      NULL,
      1.902022,
      NULL,
      0.530987,
      1.084535,
      NULL,
      0,
      0.017680,
      1.048627,
      0.922388,
      NULL,
      3,
      1.689846,
      4.096645,
      0.358010,
      1.918191,
      NULL,
      0,
      0.531454,
      6.531963,
      1.199739,
      9,
      0.580561,
      1,
      NULL,
      1,
      0,
      4,
      5,
      0,
      1.020364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.776765,
      NULL,
      1.343359,
      NULL,
      0,
      0.083890,
      1,
      1,
      2,
      NULL,
      2.208983,
      NULL,
      1.110430,
      1.396805,
      1.280366,
      1,
      0.469962,
      0.534105,
      1.233038,
      1,
      9,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      6,
      1.114430,
      NULL,
      7,
      1,
      0,
      0.191441,
      0,
      NULL,
      1.833037,
      1.929839,
      1,
      0.142991,
      0,
      1,
      1,
      0.437573,
      NULL,
      NULL,
      1,
      3.344788,
      0.329541,
      NULL,
      3.148290,
      NULL,
      8,
      NULL,
      4,
      0,
      NULL,
      4,
      3,
      4.212698,
      NULL,
      NULL,
      0.207475,
      11,
      8.163557,
      NULL,
      1.362168,
      1.084259,
      0.281694,
      2.702383,
      2.675468,
      2,
      3.156885,
      2,
      NULL,
      1.602215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.850424,
      1,
      2,
      1.872408,
      0,
      1.654430,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.167164,
      NULL,
      2,
      1,
      0.131856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.710155,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.387641,
      0.104732,
      2,
      0.785114,
      2,
      4,
      NULL,
      NULL,
      NULL,
      0.099141,
      3.175961,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.515921,
      3.108408,
      3,
      3,
      NULL,
      3.884586,
      2,
      NULL,
      1.949463,
      NULL,
      3.283253,
      0,
      0.789629,
      0,
      1.997538,
      0,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.898568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.208818,
      '24431',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      0.166743,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


