set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      NULL,
      NULL,
      '4000200',
      NULL,
      4,
      0.212236,
      1,
      '321413',
      NULL,
      ' 6-17-1991',
      7.311465,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.005887,
      0,
      1,
      1,
      1.948165,
      0,
      3.652578,
      1.306004,
      2.954675,
      1.767946,
      0.261022,
      3,
      0,
      0,
      0,
      0.653273,
      8.449021,
      1.173580,
      NULL,
      1,
      0,
      NULL,
      NULL,
      5.091064,
      2.746675,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.302963,
      7,
      3,
      0.479272,
      NULL,
      0,
      0.032222,
      1.598602,
      NULL,
      1,
      0.581888,
      NULL,
      0,
      NULL,
      0,
      1.305185,
      NULL,
      0,
      1.179921,
      0,
      1.436775,
      0,
      NULL,
      1,
      0,
      1.428325,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6.756293,
      1.802627,
      NULL,
      2,
      5,
      0,
      1.530035,
      0.617867,
      1.601573,
      0.847836,
      0.530278,
      NULL,
      1.685062,
      NULL,
      NULL,
      0.353898,
      0,
      NULL,
      NULL,
      1.722952,
      2,
      5.029710,
      NULL,
      4.455544,
      1,
      0,
      1,
      3.364228,
      7,
      NULL,
      6.619994,
      0.156814,
      0,
      NULL,
      8.236662,
      NULL,
      5.906688,
      3,
      3.191224,
      2,
      5.319471,
      6,
      2.681566,
      5.039291,
      6,
      NULL,
      5.698472,
      2.629468,
      1.566878,
      NULL,
      6.750440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.625265,
      0,
      NULL,
      0.583817,
      1,
      NULL,
      1.848737,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.212052,
      0,
      1.035734,
      1.638594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.353321,
      3.822709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.812430,
      0,
      2.873904,
      1,
      0,
      4,
      0.283493,
      NULL,
      NULL,
      0.369282,
      0.257363,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.314130,
      2,
      0.389437,
      1,
      2,
      2,
      NULL,
      0.986821,
      3.128386,
      1.332910,
      0.165748,
      NULL,
      NULL,
      0.253603,
      0.319773,
      0,
      0.597147,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.934210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      '',
      NULL,
      0.368471,
      NULL,
      '',
      '',
      1.798083,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


