set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      NULL,
      NULL,
      '1122413',
      42,
      2,
      2,
      2,
      '142122',
      NULL,
      NULL,
      37,
      NULL,
      1.677132,
      NULL,
      0.577806,
      2,
      NULL,
      0,
      0.298631,
      1,
      1.727185,
      NULL,
      0.972620,
      1.537361,
      2,
      0.869280,
      1,
      3,
      1,
      5.953807,
      NULL,
      0.968159,
      NULL,
      0,
      3.165727,
      0,
      2.780948,
      0,
      3.340645,
      NULL,
      2.198086,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      0.506188,
      1.658665,
      2,
      NULL,
      1,
      1.159758,
      1,
      0.292685,
      3,
      1,
      NULL,
      0,
      NULL,
      0.066769,
      2,
      1,
      0.792621,
      0,
      7,
      0,
      1.711464,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0.346986,
      NULL,
      NULL,
      0.533853,
      5.954810,
      NULL,
      NULL,
      6.388020,
      1.826729,
      NULL,
      0.397236,
      1.251031,
      1,
      NULL,
      6.233841,
      1,
      NULL,
      0,
      1.546430,
      1,
      0,
      0.419905,
      NULL,
      1,
      3.761251,
      5,
      1,
      NULL,
      1.144621,
      1.894665,
      0,
      NULL,
      0.672934,
      5,
      NULL,
      5,
      1,
      3,
      8,
      4,
      NULL,
      NULL,
      11,
      NULL,
      0,
      8,
      11,
      5.835527,
      5,
      NULL,
      3,
      0.366791,
      1,
      NULL,
      7.583867,
      0.885880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.647742,
      0,
      1,
      0,
      1.246302,
      2.278345,
      0.144690,
      0.722685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7.232861,
      1.388030,
      NULL,
      4,
      1.361380,
      0.501384,
      1,
      NULL,
      2.497927,
      1.128718,
      0,
      1.337494,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      0,
      2,
      1.565350,
      NULL,
      NULL,
      1,
      3.172839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      1.653715,
      0,
      0,
      0.659820,
      1,
      1,
      2.860691,
      2.388458,
      1.401375,
      1,
      0,
      0.457984,
      0,
      0.885035,
      0.912707,
      1.036524,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.028024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '34120',
      NULL,
      '',
      1.322932,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


