set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      NULL,
      NULL,
      '0142034',
      26,
      1,
      2.582387,
      1,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      NULL,
      0.634987,
      NULL,
      0,
      0.962987,
      3,
      0.389304,
      NULL,
      NULL,
      2.277223,
      0,
      5.870411,
      NULL,
      1.212078,
      0,
      1.501230,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.965821,
      2.737289,
      NULL,
      0,
      NULL,
      3.966392,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.995197,
      2,
      NULL,
      2,
      1,
      0,
      2.007633,
      NULL,
      0,
      0.684501,
      0,
      0,
      0.068611,
      2.835836,
      0.042535,
      NULL,
      0,
      1,
      1.316941,
      0,
      0,
      0.363674,
      6,
      1,
      1,
      NULL,
      1.356119,
      NULL,
      NULL,
      0.553799,
      NULL,
      NULL,
      1.200548,
      3.879550,
      NULL,
      NULL,
      9,
      8,
      7.640233,
      2.896319,
      NULL,
      1.067362,
      0,
      7.577094,
      0.088658,
      0.668648,
      0,
      0,
      0,
      1,
      0,
      NULL,
      0.015396,
      5.709403,
      4.758852,
      NULL,
      7,
      0.631114,
      3,
      0,
      4,
      0,
      1,
      7.546780,
      2.220797,
      0,
      2,
      4,
      3.152170,
      8,
      5,
      7.775807,
      5,
      3.492280,
      7.146433,
      NULL,
      NULL,
      6.201369,
      3,
      2,
      2,
      0,
      1,
      7,
      0.998597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      1.340205,
      NULL,
      0.405827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.592877,
      1.708199,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      9,
      1.570591,
      0.884065,
      0,
      5,
      0.656723,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.933197,
      1,
      3.592557,
      1.614771,
      2,
      1.450610,
      NULL,
      3.410748,
      2.357447,
      0,
      0.523955,
      1,
      NULL,
      0,
      1.073406,
      1,
      1.426084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.261548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '23340',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1.454474,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


