set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-1-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      '2232013',
      22.330995,
      1,
      3.381981,
      2,
      '440040',
      0,
      NULL,
      2.750172,
      NULL,
      0,
      NULL,
      1,
      0.385209,
      1,
      1,
      0.398126,
      2,
      1,
      1,
      1,
      1.203747,
      5,
      0,
      0,
      NULL,
      1.750387,
      0.986829,
      2.411695,
      3,
      1.359306,
      5.972784,
      1,
      0,
      1,
      0,
      4.373072,
      2,
      2,
      1.461161,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.600599,
      2.066976,
      1,
      1,
      NULL,
      1,
      2.046227,
      0.715258,
      1,
      0,
      3.755158,
      1.990344,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.299364,
      3.260807,
      1,
      NULL,
      2.683929,
      1,
      1,
      2.059466,
      0,
      NULL,
      NULL,
      0.378752,
      NULL,
      NULL,
      1.736314,
      5,
      1.809377,
      4,
      0.422122,
      3,
      5,
      3,
      3.657850,
      0.559307,
      1,
      NULL,
      1,
      2.131658,
      0.454017,
      1.673174,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.952657,
      1,
      1,
      1.352960,
      6,
      0,
      5.470734,
      5,
      0.179423,
      4,
      4,
      NULL,
      NULL,
      1.946212,
      1,
      11,
      0.645793,
      NULL,
      NULL,
      4.667666,
      2,
      4,
      9.645501,
      0.523164,
      5.631802,
      3.840649,
      3.587707,
      0,
      NULL,
      6.808541,
      0.435184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.437199,
      NULL,
      0,
      NULL,
      0.655719,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      8.316494,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.651898,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.099445,
      1,
      NULL,
      0,
      NULL,
      0.427524,
      NULL,
      NULL,
      NULL,
      0,
      7.519790,
      1.163881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.427321,
      1,
      0,
      0.955987,
      2,
      1,
      1,
      2,
      1.297956,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0.142597,
      0.843878,
      0.868439,
      0.771861,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '20242',
      '',
      '',
      0,
      '',
      '',
      '',
      1.950242,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


