set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-6-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      NULL,
      NULL,
      '2132010',
      25.321659,
      1,
      0,
      NULL,
      NULL,
      1.040460,
      ' 3-29-2000',
      NULL,
      NULL,
      1.911010,
      NULL,
      1.628971,
      2,
      0,
      1.103992,
      2,
      0.562185,
      NULL,
      0,
      NULL,
      1.166395,
      4,
      0,
      NULL,
      0.911454,
      NULL,
      6,
      9.510679,
      1.413936,
      NULL,
      0,
      4,
      NULL,
      4,
      0,
      0.314828,
      3,
      1.809541,
      0,
      NULL,
      NULL,
      1.791368,
      NULL,
      NULL,
      0,
      2.096352,
      1,
      3.613314,
      0.396716,
      0,
      NULL,
      NULL,
      NULL,
      0.560407,
      1.489203,
      1,
      3,
      0,
      1.930494,
      NULL,
      0.265603,
      1.082322,
      1,
      NULL,
      0,
      0.442520,
      0.606177,
      1,
      0,
      1.717755,
      NULL,
      NULL,
      NULL,
      0.535092,
      NULL,
      NULL,
      0,
      3,
      4.024206,
      0,
      3,
      1.382426,
      5.834323,
      1.531949,
      3,
      0.875267,
      0.187009,
      5.609075,
      0.707704,
      1.870339,
      1.152836,
      1,
      1,
      0.719859,
      1.112804,
      NULL,
      1.183697,
      7.103233,
      3.166178,
      5.000685,
      2,
      0.437434,
      4,
      1.273913,
      NULL,
      1,
      0,
      1,
      4,
      NULL,
      2.459569,
      2,
      7,
      6,
      1,
      9,
      2.494771,
      2,
      5.539560,
      9,
      4.689834,
      1,
      3.085555,
      NULL,
      3,
      NULL,
      NULL,
      3.785579,
      1.699060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.068469,
      0,
      0,
      1.087497,
      0.988345,
      0.038017,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      2.905168,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.847541,
      1.554434,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.359683,
      1.115876,
      0,
      0.413021,
      0.974672,
      0,
      1,
      3.665918,
      0.899224,
      2.813767,
      3.933681,
      1.752094,
      1,
      0.527660,
      0.667928,
      1,
      0,
      0,
      1.540454,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.029913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '31231',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


