set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-12-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      NULL,
      NULL,
      '1433143',
      78.117891,
      NULL,
      2,
      2,
      '444341',
      NULL,
      ' 9-25-1992',
      NULL,
      NULL,
      0.358560,
      NULL,
      0.185955,
      0,
      0,
      0,
      NULL,
      0,
      0.941850,
      1,
      0,
      0.513652,
      4.590526,
      1,
      0,
      1.324262,
      2.950649,
      2,
      0,
      1.309394,
      5.505905,
      0.340981,
      9,
      NULL,
      3,
      0,
      4,
      3.065959,
      3,
      1.515780,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.195766,
      NULL,
      1,
      NULL,
      0,
      3.499069,
      0,
      3.431657,
      1.129963,
      2.657782,
      0,
      0,
      2.511798,
      0,
      1,
      0,
      1,
      0,
      2.479197,
      0.376240,
      0,
      4.237224,
      0,
      0,
      NULL,
      0.560301,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.330482,
      2,
      1,
      2.645950,
      3.712135,
      0.801205,
      4,
      1.398892,
      NULL,
      1.496890,
      1,
      2,
      0.984177,
      4,
      1.365746,
      1,
      1.439390,
      1.029782,
      0,
      NULL,
      NULL,
      1.525637,
      3,
      NULL,
      NULL,
      NULL,
      2,
      1.452861,
      3,
      1,
      0.520518,
      2,
      3.638332,
      NULL,
      0.350990,
      0.294822,
      4,
      6.976682,
      0.337021,
      9.968775,
      8.890386,
      NULL,
      6.747108,
      5.852167,
      7,
      5.508399,
      0.859690,
      4.706495,
      1,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.494331,
      1,
      1,
      0.013755,
      0.067041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.733256,
      0,
      0.612594,
      3,
      0.082419,
      NULL,
      9,
      0.746093,
      NULL,
      NULL,
      NULL,
      NULL,
      5.200924,
      1,
      NULL,
      5,
      0,
      1,
      4.351725,
      1.534356,
      NULL,
      NULL,
      1,
      1,
      1.133486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.818983,
      1,
      2.288416,
      NULL,
      NULL,
      2.444723,
      0,
      0,
      2,
      0.286390,
      NULL,
      1,
      1.527136,
      0.271397,
      1,
      1,
      0.171429,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.927441,
      '33031',
      NULL,
      '',
      1.392409,
      '',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


