set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-12-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      NULL,
      NULL,
      '2444101',
      145.212775,
      2,
      NULL,
      3,
      '314042',
      0.689307,
      ' 8- 8-1996',
      23,
      NULL,
      1,
      NULL,
      0.834555,
      0,
      0.667895,
      NULL,
      1.810893,
      2.058180,
      1.001757,
      1.129764,
      0.810526,
      0.501519,
      1.134771,
      1,
      0.917914,
      1,
      0.858197,
      3,
      8.341683,
      3.331060,
      0.638229,
      10,
      NULL,
      11,
      2.871039,
      0,
      NULL,
      2.254757,
      0.217306,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1.249387,
      0,
      0,
      1.249709,
      1,
      0,
      0.499659,
      NULL,
      1.462657,
      1.044770,
      NULL,
      1.605241,
      0.607257,
      NULL,
      0,
      1,
      1.982791,
      0,
      8,
      0.774101,
      2,
      7,
      1,
      1,
      3.070140,
      1.865933,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      4,
      1.269931,
      0,
      NULL,
      5.299805,
      2.151041,
      0.072428,
      1,
      1.779504,
      1,
      1,
      0,
      0,
      1,
      NULL,
      1.057765,
      0.019334,
      NULL,
      0,
      NULL,
      0,
      1,
      2.458840,
      1.218697,
      4,
      NULL,
      2.757035,
      1,
      3.634370,
      2.211735,
      2,
      1.498826,
      3,
      NULL,
      2.091333,
      5,
      NULL,
      0,
      NULL,
      3,
      2.646636,
      NULL,
      9,
      0.745079,
      0.236332,
      5,
      1.926055,
      0,
      1.642330,
      0.850863,
      0.469855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666940,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3,
      2,
      0,
      0,
      4,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.588938,
      1,
      1.621682,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.469407,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.053172,
      1.855326,
      1,
      2,
      0.151457,
      1.948406,
      0,
      0.436711,
      NULL,
      0.783015,
      1.573901,
      NULL,
      1.409798,
      1.419392,
      1,
      0.024247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '42344',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      1.705806,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


